/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.render.entities;

import com.hungteen.pvzmod.render.entities.EntityTFSnowQueenIceShield;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityTFSnowQueen
extends EntityMob
implements IEntityMultiPart {
    private static final int MAX_SUMMONS = 6;
    private static final DataParameter<Boolean> BEAM_FLAG = EntityDataManager.func_187226_a(EntityTFSnowQueen.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> PHASE_FLAG = EntityDataManager.func_187226_a(EntityTFSnowQueen.class, (DataSerializer)DataSerializers.field_187191_a);
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS);
    private static final int MAX_DAMAGE_WHILE_BEAMING = 25;
    private static final float BREATH_DAMAGE = 4.0f;
    public final Entity[] iceArray = new Entity[7];
    private int summonsRemaining = 0;
    private int successfulDrops;
    private int maxDrops;
    private int damageWhileBeaming;

    public EntityTFSnowQueen(World world) {
        super(world);
        this.func_70105_a(0.7f, 2.2f);
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i] = new EntityTFSnowQueenIceShield(this);
        }
        this.setCurrentPhase(Phase.SUMMON);
        this.field_70178_ae = true;
        this.field_70728_aV = 317;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BEAM_FLAG, (Object)false);
        this.field_70180_af.func_187214_a(PHASE_FLAG, (Object)0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i].func_70071_h_();
            if (i < this.iceArray.length - 1) {
                Vec3d blockPos = this.getIceShieldPosition(i);
                this.iceArray[i].func_70107_b(blockPos.field_72450_a, blockPos.field_72448_b, blockPos.field_72449_c);
                this.iceArray[i].field_70177_z = this.getIceShieldAngle(i);
            } else {
                this.iceArray[i].func_70107_b(this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v);
                this.iceArray[i].field_70177_z = this.getIceShieldAngle(i);
            }
            if (this.field_70170_p.field_72995_K) continue;
            this.applyShieldCollisions(this.iceArray[i]);
        }
        if (this.field_70725_aQ > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                EnumParticleTypes explosionType = this.field_70146_Z.nextBoolean() ? EnumParticleTypes.EXPLOSION_HUGE : EnumParticleTypes.EXPLOSION_NORMAL;
                this.field_70170_p.func_175688_a(explosionType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
            }
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        } else {
            super.func_70623_bb();
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }

    private void applyShieldCollisions(Entity collider) {
        List list = this.field_70170_p.func_72839_b(collider, collider.func_174813_aQ().func_72314_b((double)-0.2f, (double)-0.2f, (double)-0.2f));
        for (Entity collided : list) {
            if (!collided.func_70104_M()) continue;
            this.applyShieldCollision(collider, collided);
        }
    }

    private void applyShieldCollision(Entity collider, Entity collided) {
        if (collided != this) {
            collided.func_70108_f(collider);
            if (collided instanceof EntityLivingBase && super.func_70652_k(collided)) {
                collided.field_70181_x += 0.4;
                this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        boolean result = super.func_70097_a(source, damage);
        if (result && this.getCurrentPhase() == Phase.BEAM) {
            this.damageWhileBeaming = (int)((float)this.damageWhileBeaming + damage);
        }
        return result;
    }

    private Vec3d getIceShieldPosition(int idx) {
        return this.getIceShieldPosition(this.getIceShieldAngle(idx), 1.0f);
    }

    private float getIceShieldAngle(int idx) {
        return 60.0f * (float)idx + (float)this.field_70173_aa * 5.0f;
    }

    private Vec3d getIceShieldPosition(float angle, float distance) {
        double dx = 3.0 * Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
        double dz = 3.0 * Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return new Vec3d(this.field_70165_t + dx, this.field_70163_u + this.getShieldYOffset(), this.field_70161_v + dz);
    }

    private double getShieldYOffset() {
        return 0.1f;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.iceArray;
    }

    public Phase getCurrentPhase() {
        return Phase.values()[(Byte)this.field_70180_af.func_187225_a(PHASE_FLAG)];
    }

    public void setCurrentPhase(Phase currentPhase) {
        this.field_70180_af.func_187227_b(PHASE_FLAG, (Object)((byte)currentPhase.ordinal()));
        if (currentPhase == Phase.SUMMON) {
            this.setSummonsRemaining(6);
        }
        if (currentPhase == Phase.DROP) {
            this.successfulDrops = 0;
            this.maxDrops = 2 + this.field_70146_Z.nextInt(3);
        }
        if (currentPhase == Phase.BEAM) {
            this.damageWhileBeaming = 0;
        }
    }

    public int getSummonsRemaining() {
        return this.summonsRemaining;
    }

    public void setSummonsRemaining(int summonsRemaining) {
        this.summonsRemaining = summonsRemaining;
    }

    public void incrementSuccessfulDrops() {
        ++this.successfulDrops;
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    public static enum Phase {
        SUMMON,
        DROP,
        BEAM;

    }
}

