/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.util;

import com.hungteen.pvzmod.util.enums.Difficulty;
import net.minecraftforge.common.config.Config;

public class ConfigurationUtil {
    public static int getPVZDifficulty() {
        return MainConfig.globalSettings.pvzDifficulty.ordinal();
    }

    @Config(modid="pvz", type=Config.Type.INSTANCE, name="pvz/main_config")
    @Config.LangKey(value="gui.pvzconfig.title")
    public static class MainConfig {
        @Config.Comment(value={"Configure the global settings"})
        @Config.LangKey(value="gui.pvzconfig.globalSettings")
        public static final SubCategoryGlobalSettings globalSettings = new SubCategoryGlobalSettings();
        @Config.Comment(value={"Configure damage settings"})
        @Config.LangKey(value="gui.pvzconfig.damageSettings")
        public static final SubCategoryDamageSettings damageSettings = new SubCategoryDamageSettings();
        @Config.Comment(value={"Configure random events"})
        @Config.LangKey(value="gui.pvzconfig.eventSettings")
        public static final SubCategoryEventSettings eventSettings = new SubCategoryEventSettings();
        @Config.Comment(value={"Configure display"})
        @Config.LangKey(value="gui.pvzconfig.displaySettings")
        public static final SubCategoryDisplaySettings displaySettings = new SubCategoryDisplaySettings();

        public static class SubCategoryDisplaySettings {
            @Config.Comment(value={"Show sun amount bar"})
            @Config.LangKey(value="gui.pvzconfig.showSun")
            public boolean showSunNum = true;
            @Config.Comment(value={"Show energy amount bar"})
            @Config.LangKey(value="gui.pvzconfig.showEnergy")
            public boolean showEnergyNum = true;
            @Config.Comment(value={"Show money amount bar"})
            @Config.LangKey(value="gui.pvzconfig.showMoney")
            public boolean showMoneyNum = true;
        }

        public static class SubCategoryEventSettings {
            @Config.Comment(value={"Chance for the Plant-Zombie-Event to occur. Value is represented as a chance of 1/n."})
            @Config.LangKey(value="gui.pvzconfig.plantZombieEventChance")
            @Config.RangeInt(min=1, max=1000000)
            public int plantZombieEventChance = 15;
            @Config.Comment(value={"Chance for the Mini-Zombie-Event to occur. Value is represented as a chance of 1/n."})
            @Config.LangKey(value="gui.pvzconfig.miniZombieEventChance")
            @Config.RangeInt(min=1, max=1000000)
            public int miniZombieEventChance = 15;
            @Config.Comment(value={"Chance for the Invis-Zombie-Event to occur. Value is represented as a chance of 1/n."})
            @Config.LangKey(value="gui.pvzconfig.invisZombieEventChance")
            @Config.RangeInt(min=1, max=1000000)
            public int invisZombieEventChance = 15;
            @Config.Comment(value={"How many days can avoid the zombie events happen. If set to 3, then zombi events will happen after 3 days."})
            @Config.LangKey(value="gui.pvzconfig.safeDayLength")
            @Config.RangeInt(min=1, max=1000000)
            public int safeDayLength = 3;
            @Config.Comment(value={"The chance to happen zombie invasion.if set to 80, the chance is 80%."})
            @Config.LangKey(value="gui.pvzconfig.safeDayLength")
            @Config.RangeInt(min=0, max=100)
            public int invadeChance = 80;
        }

        public static class SubCategoryDamageSettings {
            @Config.Comment(value={"Plants can hurt the other teams when it's true)"})
            @Config.LangKey(value="gui.pvzconfig.canPlantHurtTeams")
            public boolean canPlantHurtOtherTeams = false;
            @Config.Comment(value={"Can bullet pass through the entities that it can't hurt"})
            @Config.LangKey(value="gui.pvzconfig.canBulletPassEntity")
            public boolean canBulletPassEntity = true;
        }

        public static class SubCategoryGlobalSettings {
            @Config.Comment(value={"different with default difficulty"})
            @Config.LangKey(value="gui.pvzconfig.difficulty")
            public Difficulty pvzDifficulty = Difficulty.NORMAL;
        }
    }
}

