/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.util;

import com.hungteen.pvzmod.entities.plants.base.EntityPlantBase;
import com.hungteen.pvzmod.entities.plants.defence.EntityPumpkin;
import com.hungteen.pvzmod.entities.plants.fight.EntitySpikeRock;
import com.hungteen.pvzmod.entities.plants.fight.EntitySquash;
import com.hungteen.pvzmod.entities.plants.flame.EntityJalapeno;
import com.hungteen.pvzmod.entities.plants.ice.EntityIceShroom;
import com.hungteen.pvzmod.entities.zombies.base.EntityZombieBase;
import com.hungteen.pvzmod.entities.zombies.roof.EntityImp;
import com.hungteen.pvzmod.entities.zombies.special.EntityDolphin;
import com.hungteen.pvzmod.entities.zombies.special.EntityDuckyTube;
import com.hungteen.pvzmod.entities.zombies.special.EntityElementBall;
import com.hungteen.pvzmod.entities.zombies.special.EntityNormalDefence;
import com.hungteen.pvzmod.util.ConfigurationUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityUtil {
    public static double getAttackRange(Entity a, Entity b, double r) {
        return ((double)(a.field_70130_N / 2.0f + b.field_70130_N) + r) * ((double)(a.field_70130_N / 2.0f + b.field_70130_N) + r);
    }

    public static boolean isOnGround(Entity entity) {
        BlockPos pos = new BlockPos(entity);
        return entity.field_70170_p.func_180495_p(pos = pos.func_177982_a(0, -1, 0)).func_185904_a() != Material.field_151579_a && entity.field_70163_u - (double)pos.func_177956_o() <= 1.1;
    }

    public static List<EntityLivingBase> getEntityAttackableTarget(EntityLivingBase attacker, AxisAlignedBB aabb) {
        World world = attacker.field_70170_p;
        ArrayList<EntityLivingBase> list = new ArrayList<EntityLivingBase>();
        for (EntityLivingBase entity : world.func_72872_a(EntityLivingBase.class, aabb)) {
            if (!EntityUtil.checkCanEntityAttack((Entity)attacker, (Entity)entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public static boolean checkCanEntityAttack(Entity attacker, Entity target) {
        int targetGroup;
        int attackerGroup;
        boolean flag;
        if (attacker == null || target == null) {
            return false;
        }
        World world = attacker.field_70170_p;
        if (target instanceof EntityPlayer && (((EntityPlayer)target).func_184812_l_() || ((EntityPlayer)target).func_175149_v())) {
            return false;
        }
        if (target instanceof EntityZombieBase) {
            if (target instanceof EntityDuckyTube) {
                return false;
            }
            if (target instanceof EntityDolphin) {
                return false;
            }
            if (target instanceof EntityImp && target.func_184218_aH()) {
                return false;
            }
        }
        if (flag = ConfigurationUtil.MainConfig.damageSettings.canPlantHurtOtherTeams) {
            Team team1 = EntityUtil.getEntityTeam(world, attacker);
            Team team2 = EntityUtil.getEntityTeam(world, target);
            if (team1 != null && team2 != null) {
                if (EntityUtil.getIsEntityCharmed(attacker)) {
                    return team1.func_142054_a(team2);
                }
                return !team1.func_142054_a(team2);
            }
        }
        if ((attackerGroup = EntityUtil.getEntityGroup(attacker)) * (targetGroup = EntityUtil.getEntityGroup(target)) < 0) {
            if (target instanceof EntityElementBall) {
                if (((EntityElementBall)target).getBallState() == EntityElementBall.State.FLAME && attacker instanceof EntityIceShroom) {
                    return true;
                }
                return ((EntityElementBall)target).getBallState() == EntityElementBall.State.ICE && attacker instanceof EntityJalapeno;
            }
            return true;
        }
        return false;
    }

    public static int getEntityGroup(Entity entity) {
        int entityGroup = 0;
        if (entity instanceof EntityPlayer) {
            entityGroup = 2;
        } else if (entity instanceof EntityPlantBase) {
            entityGroup = ((EntityPlantBase)entity).getIsCharmed() ? -1 : 1;
        } else if (entity instanceof EntityMob) {
            entityGroup = -1;
            if (entity instanceof EntityZombieBase && ((EntityZombieBase)entity).getIsCharmed()) {
                entityGroup = 1;
            }
        } else if (entity instanceof EntityNormalDefence) {
            entityGroup = -1;
            EntityZombieBase zombie = ((EntityNormalDefence)entity).getOwner();
            if (zombie instanceof EntityZombieBase && zombie.getIsCharmed()) {
                entityGroup = 1;
            }
        }
        return entityGroup;
    }

    public static boolean getIsEntityCharmed(Entity entity) {
        if (entity instanceof EntityPlantBase) {
            return ((EntityPlantBase)entity).getIsCharmed();
        }
        if (entity instanceof EntityZombieBase) {
            return ((EntityZombieBase)entity).getIsCharmed();
        }
        return false;
    }

    public static Team getEntityTeam(World world, Entity entity) {
        String name;
        if (entity instanceof EntityPlayer) {
            return ((EntityPlayer)entity).func_96124_cp();
        }
        if (entity instanceof EntityPlantBase) {
            String name2 = ((EntityPlantBase)entity).getOwnerName();
            if (name2 != "") {
                EntityPlayer player = world.func_72924_a(name2);
                if (player == null) {
                    return null;
                }
                return player.func_96124_cp();
            }
        } else if (entity instanceof EntityZombieBase && (name = ((EntityZombieBase)entity).getOwnerName()) != "") {
            EntityPlayer player = world.func_72924_a(name);
            if (player == null) {
                return null;
            }
            return player.func_96124_cp();
        }
        return null;
    }

    public static boolean checkShouldApplyCollision(Entity base, Entity target) {
        if (base instanceof EntityPlantBase) {
            if (target instanceof EntityPlayer) {
                return false;
            }
            if (target instanceof EntityPumpkin) {
                return base instanceof EntityPumpkin;
            }
            if (base instanceof EntityPumpkin) {
                return target instanceof EntityPumpkin;
            }
            if (base instanceof EntitySquash) {
                if (EntityUtil.checkCanEntityAttack(base, target) && ((EntityPlantBase)base).getAttackTime() == 0) {
                    return true;
                }
                return target instanceof EntitySquash;
            }
        } else if (base instanceof EntityZombieBase) {
            if (target instanceof EntitySpikeRock) {
                return false;
            }
            if (target instanceof EntitySquash) {
                return false;
            }
            if (target instanceof EntityZombieBase) {
                return false;
            }
        }
        return true;
    }

    public static double getDistanceSq(Entity owner, Entity target) {
        if (target == null) {
            return 1000.0;
        }
        double d0 = owner.field_70165_t - target.field_70165_t;
        double d1 = owner.field_70163_u - target.field_70163_u;
        double d2 = owner.field_70161_v - target.field_70161_v;
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
    }
}

