/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.util;

import com.hungteen.pvzmod.capability.data.PlayerDataManager;
import com.hungteen.pvzmod.capability.handler.PVZPlayerCapability;
import com.hungteen.pvzmod.capability.provider.PVZPlayerProvider;
import com.hungteen.pvzmod.util.enums.Plants;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;

public class PlayerUtil {
    @Nonnull
    public static PlayerDataManager getPVZPlayer(@Nonnull EntityPlayer player) {
        PVZPlayerCapability cap = (PVZPlayerCapability)player.getCapability(PVZPlayerProvider.PVZ_PLAYER, null);
        if (cap == null) {
            cap = new PVZPlayerCapability();
            cap.init(player);
            System.out.println("Player: " + player.func_70005_c_() + " doesn't have an attached PVZPlayer capability. Something is very wrong here.");
        }
        if (cap.getPlayerData() == null) {
            cap.init(player);
        }
        return cap.getPlayerData();
    }

    public static int getPlayerMaxSunNum(int lvl) {
        if (lvl <= 10) {
            return 100 * lvl;
        }
        if (lvl <= 20) {
            return 150 * (lvl - 10) + 1000;
        }
        if (lvl <= 40) {
            return 125 * (lvl - 20) + 2500;
        }
        if (lvl <= 60) {
            return 250 * (lvl - 40) + 5000;
        }
        if (lvl <= 80) {
            return 2000 * (lvl - 60) + 10000;
        }
        if (lvl <= 99) {
            return 2500 * (lvl - 80) + 50000;
        }
        return 99999;
    }

    public static int getPlayerMaxEnergyNum(int lvl) {
        return 1 + lvl / 20;
    }

    public static int getPlayerLevelUpXp(int lvl) {
        if (lvl <= 10) {
            return 5 * lvl;
        }
        if (lvl <= 20) {
            return 50 + (lvl - 10) * 10;
        }
        if (lvl <= 30) {
            return 150 + (lvl - 20) * 30;
        }
        if (lvl <= 40) {
            return 450 + (lvl - 30) * 75;
        }
        if (lvl <= 50) {
            return 1200 + (lvl - 40) * 150;
        }
        if (lvl <= 60) {
            return 2700 + (lvl - 50) * 300;
        }
        if (lvl <= 70) {
            return 5700 + (lvl - 60) * 500;
        }
        if (lvl <= 80) {
            return 10700 + (lvl - 70) * 1000;
        }
        if (lvl <= 90) {
            return 20700 + (lvl - 80) * 2000;
        }
        if (lvl <= 100) {
            return 40700 + (lvl - 90) * 4000;
        }
        return 100000;
    }

    public static int getPlantLvl(EntityPlayer player, Plants plant) {
        return PlayerUtil.getPVZPlayer(player).getPlantStats().getPlantLevel(plant);
    }

    public static int getPlayerSunNum(EntityPlayer player) {
        return PlayerUtil.getPVZPlayer(player).getPlayerStats().getPlayerSunNum();
    }

    public static int getPlayerEnergyNum(EntityPlayer player) {
        return PlayerUtil.getPVZPlayer(player).getPlayerStats().getPlayerEnergyNum();
    }

    public static void addPlantCardNum(EntityPlayer player, Plants plant, int xp) {
        int lvl = PlayerUtil.getPlantLvl(player, plant);
        PlayerUtil.getPVZPlayer(player).getPlantStats().addPlantXp(plant, xp);
    }

    public static void addPlayerXp(EntityPlayer player, int xp) {
        PlayerUtil.getPVZPlayer(player).getPlayerStats().addPlayerXp(xp);
    }

    public static void addPlayerSunNum(EntityPlayer player, int num) {
        PlayerUtil.getPVZPlayer(player).getPlayerStats().addPlayerSunNum(num);
    }

    public static void addPlayerMoney(EntityPlayer player, int num) {
        PlayerUtil.getPVZPlayer(player).getPlayerStats().addPlayerMoney(num);
    }

    public static void addPlayerEnergyNum(EntityPlayer player, int num) {
        PlayerUtil.getPVZPlayer(player).getPlayerStats().addPlayerEnergyNum(num);
    }

    public static void clonePlayerData(EntityPlayer sourcePlayer, EntityPlayer targetPlayer) {
        PlayerUtil.getPVZPlayer(targetPlayer).cloneFromExistingPlayerData(PlayerUtil.getPVZPlayer(sourcePlayer));
    }
}

