/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.world.gen;

import com.hungteen.pvzmod.util.BiomeUtil;
import com.hungteen.pvzmod.util.WorldUtil;
import com.hungteen.pvzmod.world.gen.generators.WorldGenStructure;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenStructures
implements IWorldGenerator {
    public static final WorldGenStructure DAVEVILLA = new WorldGenStructure("davevilla1");
    public static final WorldGenStructure DAVEVILLA2 = new WorldGenStructure("davevilla2");
    public static final WorldGenStructure DAVEVILLA3 = new WorldGenStructure("davevilla3");
    public static final WorldGenStructure DAVEVILLA4 = new WorldGenStructure("davevilla4");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                break;
            }
            case 0: {
                this.generateStructure(DAVEVILLA, world, random, chunkX, chunkZ, 300, (Block)Blocks.field_150349_c, BiomeUtil.plain);
                break;
            }
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Biome ... biomes) {
        ArrayList<Biome> generateBiomes = new ArrayList<Biome>();
        for (Biome biome : biomes) {
            generateBiomes.add(biome);
        }
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int y = WorldUtil.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Biome nowBiome = world.getBiomeForCoordsBody(pos);
        if (world.func_175624_G() != WorldType.field_77138_c && generateBiomes.contains(nowBiome) && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
            DAVEVILLA2.func_180709_b(world, random, pos.func_177982_a(32, 0, 0));
            DAVEVILLA3.func_180709_b(world, random, pos.func_177982_a(0, 0, 32));
            DAVEVILLA4.func_180709_b(world, random, pos.func_177982_a(32, 0, 32));
        }
    }
}

