/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvzmod.world.gen.generators;

import com.hungteen.pvzmod.registry.BlockRegister;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenNutTree
extends WorldGenAbstractTree {
    public static final IBlockState LOG = Blocks.field_150364_r.func_176223_P();
    public static final IBlockState LEAF = BlockRegister.NUT_LEAVES.func_176223_P();
    private final int minHeight;

    public WorldGenNutTree() {
        super(false);
        this.minHeight = 12;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int height = this.minHeight + rand.nextInt(3);
        boolean flag = true;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int yPos = y; yPos <= y + 1 + height; ++yPos) {
            int b0 = 2;
            if (yPos == y) {
                b0 = 1;
            }
            if (yPos >= y + 1 + height - 2) {
                b0 = 2;
            }
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int xPos = x - b0; xPos <= x + b0 && flag; ++xPos) {
                for (int zPos = z - b0; zPos < -z + b0 && flag; ++zPos) {
                    if (yPos >= 0 && yPos < world.func_72800_K()) {
                        if (this.isReplaceable(world, new BlockPos(xPos, yPos, zPos))) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        BlockPos down = pos.func_177977_b();
        IBlockState state = world.func_180495_p(down);
        boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, down, EnumFacing.UP, (IPlantable)Blocks.field_150345_g);
        if (isSoil && y < world.func_72800_K() - height - 1) {
            state.func_177230_c().onPlantGrow(state, world, down, pos);
            for (int yPos = y - 3 + height; yPos <= y + height; ++yPos) {
                int b1 = yPos - (y + height);
                int b2 = 1 - b1 / 2;
                for (int xPos = x - b2; xPos <= x + b2; ++xPos) {
                    int b3 = xPos - x;
                    for (int zPos = z - b2; zPos <= z + b2; ++zPos) {
                        BlockPos treePos;
                        IBlockState treeState;
                        int b4 = zPos - z;
                        if (Math.abs(b3) == b2 && Math.abs(b4) == b2 && (rand.nextInt(2) == 0 || b1 == 0) || !(treeState = world.func_180495_p(treePos = new BlockPos(xPos, yPos, zPos))).func_177230_c().isAir(treeState, (IBlockAccess)world, treePos) && !treeState.func_177230_c().isAir(treeState, (IBlockAccess)world, treePos)) continue;
                        this.func_175903_a(world, treePos, LEAF);
                        this.func_175903_a(world, treePos.func_177963_a(0.0, -0.25 * (double)height, 0.0), LEAF);
                        this.func_175903_a(world, treePos.func_177963_a(0.0, -0.5 * (double)height, 0.0), LEAF);
                    }
                }
            }
            for (int logHeight = 0; logHeight < height; ++logHeight) {
                BlockPos up = pos.func_177981_b(logHeight);
                IBlockState logState = world.func_180495_p(up);
                if (!logState.func_177230_c().isAir(logState, (IBlockAccess)world, up) && !logState.func_177230_c().isLeaves(logState, (IBlockAccess)world, up)) continue;
                this.func_175903_a(world, pos.func_177981_b(logHeight), LOG);
            }
            return true;
        }
        return true;
    }

    protected boolean func_150523_a(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j || material == Material.field_151578_c || blockType == Blocks.field_150349_c || blockType == Blocks.field_150346_d || blockType == Blocks.field_150364_r || blockType == Blocks.field_150363_s || blockType == Blocks.field_150345_g || blockType == Blocks.field_150395_bd;
    }
}

