/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.block.plants;

import com.hungteen.pvz.register.ItemRegister;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class ToxicShroomBlock
extends BushBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    private static final VoxelShape[] STAGES = new VoxelShape[]{Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0)};
    private static final int VALID_LIGHT_LEVEL = 7;
    private final int POISON_TICK = 100;
    private final int POISON_LVL = 1;

    public ToxicShroomBlock(Block.Properties p_i49971_1_) {
        super(p_i49971_1_);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)ItemRegister.SPORE.get());
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        System.out.println(state.func_177230_c());
        return state.func_177230_c() == Blocks.field_150391_bh;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        System.out.println(worldIn.func_226659_b_(pos, 0) < 7);
        return block == Blocks.field_150391_bh && worldIn.func_226659_b_(pos, 0) < 7 && blockstate.canSustainPlant((IBlockReader)worldIn, blockpos, Direction.UP, (IPlantable)this);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age >= 0 && age <= 3) {
            return STAGES[age];
        }
        return STAGES[0];
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < 3 && worldIn.func_226659_b_(pos, 0) <= 7 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(10) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
        if (worldIn.field_72995_K && i == 3) {
            for (int j = 0; j < 3; ++j) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ((double)rand.nextFloat() - 0.5) / 5.0, ((double)rand.nextFloat() - 0.5) / 10.0, ((double)rand.nextFloat() - 0.5) / 5.0);
            }
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && !(entityIn instanceof MonsterEntity)) {
            entityIn.func_213295_a(state, new Vec3d((double)0.8f, 0.75, (double)0.8f));
            if (!(worldIn.field_72995_K || (Integer)state.func_177229_b((IProperty)AGE) != 3 || entityIn.field_70142_S == entityIn.func_226277_ct_() && entityIn.field_70136_U == entityIn.func_226281_cx_())) {
                double d0 = Math.abs(entityIn.func_226277_ct_() - entityIn.field_70142_S);
                double d1 = Math.abs(entityIn.func_226281_cx_() - entityIn.field_70136_U);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    LivingEntity living = (LivingEntity)entityIn;
                    living.func_195064_c(new EffectInstance(Effects.field_76436_u, this.POISON_TICK, this.POISON_LVL, false, false));
                }
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean flag;
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        boolean bl = flag = i == 3;
        if (!flag && player.func_184586_b(handIn).func_77973_b() == Items.field_196106_bc) {
            return ActionResultType.PASS;
        }
        if (i > 1) {
            int j = 1 + worldIn.field_73012_v.nextInt(1);
            ToxicShroomBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)ItemRegister.SPORE.get(), j));
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(1)), 2);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE});
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 3;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.func_177229_b((IProperty)AGE) + 1);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

