/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.command;

import com.hungteen.pvz.event.OverWorldEvents;
import com.hungteen.pvz.utils.enums.Events;
import com.hungteen.pvz.world.WaveManager;
import com.hungteen.pvz.world.data.WorldEventData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;

public class InvasionCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"invasion").requires(ctx -> ctx.func_197034_c(2));
        for (Events event : Events.values()) {
            builder.then(Commands.func_197057_a((String)"event").then(Commands.func_197057_a((String)"add").then(Commands.func_197057_a((String)event.toString().toLowerCase()).executes(commond -> InvasionCommand.addInvasionEvent((CommandSource)commond.getSource(), event)))));
        }
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"event").then(Commands.func_197057_a((String)"clear").executes(commond -> InvasionCommand.clearInvasionEvent((CommandSource)commond.getSource())))).then(Commands.func_197057_a((String)"show").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(commond -> InvasionCommand.showInvasionEvent((CommandSource)commond.getSource(), EntityArgument.func_197090_e((CommandContext)commond, (String)"targets"))))));
        builder.then(Commands.func_197057_a((String)"wave").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(commond -> InvasionCommand.spawnHugeWave(EntityArgument.func_197090_e((CommandContext)commond, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)commond, (String)"amount"))))));
        dispatcher.register(builder);
    }

    private static int spawnHugeWave(Collection<? extends ServerPlayerEntity> targets, int num) {
        targets.forEach(player -> {
            WaveManager manager = new WaveManager((PlayerEntity)player, 0);
            if (num != 0) {
                manager.spawnCnt = num;
            }
            manager.spawnWaveZombies();
        });
        return targets.size();
    }

    private static int addInvasionEvent(CommandSource source, Events event) {
        OverWorldEvents.activateEvent((World)source.func_197023_e(), event);
        return 0;
    }

    private static int clearInvasionEvent(CommandSource source) {
        OverWorldEvents.deactivateZombieAttackEvents((World)source.func_197023_e(), false);
        return 0;
    }

    private static int showInvasionEvent(CommandSource source, Collection<? extends ServerPlayerEntity> targets) {
        targets.forEach(player -> {
            WorldEventData data = WorldEventData.getOverWorldEventData((World)source.func_197023_e());
            for (Events event : Events.values()) {
                if (!data.hasEvent(event)) continue;
                player.func_145747_a(Events.getEventText(event));
            }
        });
        return targets.size();
    }
}

