/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.data;

import com.hungteen.pvz.item.PVZSpawnEggItem;
import com.hungteen.pvz.item.armor.FootballArmorItem;
import com.hungteen.pvz.item.armor.GigaArmorItem;
import com.hungteen.pvz.item.tool.card.PlantCardItem;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "pvz", existingFileHelper);
    }

    public String func_200397_b() {
        return "Plants vs Zombies item and itemblock models";
    }

    protected void registerModels() {
        for (Item i : ForgeRegistries.ITEMS) {
            if (i instanceof PVZSpawnEggItem) {
                ((ItemModelBuilder)this.getBuilder(i.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(new ResourceLocation("item/template_spawn_egg")));
                continue;
            }
            if (i instanceof PlantCardItem) {
                ResourceLocation r;
                Plants plant = ((PlantCardItem)i).plantType;
                ResourceLocation plantResource = StringUtil.prefix("screenshot/plant/" + plant.toString().toLowerCase());
                if (((PlantCardItem)i).isEnjoyCard) {
                    r = StringUtil.prefix("item/red_card");
                    this.generated(i.getRegistryName().func_110623_a(), r, plantResource);
                    continue;
                }
                r = StringUtil.prefix("item/" + PlantUtil.getPlantRankByName(plant).toString().toLowerCase() + "_card");
                this.generated(i.getRegistryName().func_110623_a(), r, plantResource);
                continue;
            }
            if (!(i instanceof FootballArmorItem) && !(i instanceof GigaArmorItem)) continue;
            this.generated(i.getRegistryName().func_110623_a(), StringUtil.prefix("item/" + i.getRegistryName().func_110623_a()));
        }
    }

    private ItemModelBuilder generated(String name, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }
}

