/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity;

import com.hungteen.pvz.PVZMod;
import com.hungteen.pvz.utils.interfaces.IMultiPartEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class PVZMultiPartEntity
extends Entity {
    private static final DataParameter<Integer> OWNER_ID = EntityDataManager.func_187226_a(PVZMultiPartEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> WIDTH = EntityDataManager.func_187226_a(PVZMultiPartEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> HEIGHT = EntityDataManager.func_187226_a(PVZMultiPartEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected final float MaxWidth;
    protected final float MaxHeight;
    private IMultiPartEntity parent;

    public PVZMultiPartEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.MaxHeight = 0.5f;
        this.MaxWidth = 0.5f;
    }

    public PVZMultiPartEntity(EntityType<?> entityTypeIn, LivingEntity owner, float sizeX, float sizeY) {
        super(entityTypeIn, owner.field_70170_p);
        if (owner instanceof IMultiPartEntity) {
            this.parent = (IMultiPartEntity)owner;
        } else {
            PVZMod.LOGGER.debug("error multipart owner");
        }
        this.MaxHeight = sizeY;
        this.MaxWidth = sizeX;
        this.setOwner(owner);
        this.setPartWidth(sizeX);
        this.setPartHeight(sizeY);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER_ID, (Object)0);
        this.field_70180_af.func_187214_a(WIDTH, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(HEIGHT, (Object)Float.valueOf(0.5f));
    }

    public void func_70071_h_() {
        this.func_213323_x_();
        if (!this.field_70170_p.field_72995_K) {
            LivingEntity owner = this.getOwner();
            if (owner != null) {
                this.func_70018_K();
                this.collideWithNearbyEntities();
                if (!owner.func_70089_S()) {
                    this.func_70106_y();
                }
            } else {
                this.func_70106_y();
            }
            if (this.shouldNotExist()) {
                this.func_70106_y();
            }
        }
        super.func_70071_h_();
    }

    public LivingEntity getOwner() {
        int id = this.getOwnerId();
        Entity entity = this.field_70170_p.func_73045_a(id);
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    public IMultiPartEntity getParent() {
        return this.parent;
    }

    public void setOwner(LivingEntity entity) {
        this.setOwnerId(entity.func_145782_y());
    }

    public boolean func_70028_i(Entity entity) {
        return this == entity || this.getOwner() == entity;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void collideWithNearbyEntities() {
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return false;
    }

    public boolean shouldNotExist() {
        LivingEntity Owner = this.getOwner();
        return !Owner.func_70089_S();
    }

    public boolean shouldContinuePersisting() {
        return this.isAddedToWorld() || this.field_70128_L;
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)this.getPartWidth(), (float)this.getPartHeight());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private int getOwnerId() {
        return (Integer)this.field_70180_af.func_187225_a(OWNER_ID);
    }

    public void setOwnerId(int OwnerId) {
        this.field_70180_af.func_187227_b(OWNER_ID, (Object)OwnerId);
    }

    public float getPartWidth() {
        return ((Float)this.field_70180_af.func_187225_a(WIDTH)).floatValue();
    }

    public void setPartWidth(float scale) {
        this.field_70180_af.func_187227_b(WIDTH, (Object)Float.valueOf(scale));
    }

    public float getPartHeight() {
        return ((Float)this.field_70180_af.func_187225_a(HEIGHT)).floatValue();
    }

    public void setPartHeight(float scale) {
        this.field_70180_af.func_187227_b(HEIGHT, (Object)Float.valueOf(scale));
    }
}

