/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.ai;

import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.ForgeHooks;

public class BreakBlockGoal
extends MoveToBlockGoal {
    protected final Block block;
    protected final MobEntity entity;
    protected int breakingTime;

    public BreakBlockGoal(Block blockIn, CreatureEntity creature, double speed, int yMax) {
        super(creature, speed, 24, yMax);
        this.block = blockIn;
        this.entity = creature;
    }

    public boolean func_75250_a() {
        if (this.entity.func_70638_az() != null) {
            return false;
        }
        if (this.entity instanceof PVZZombieEntity && !((PVZZombieEntity)this.entity).checkCanZombieBreakBlock()) {
            return false;
        }
        if (!ForgeHooks.canEntityDestroy((World)this.entity.field_70170_p, (BlockPos)this.field_179494_b, (LivingEntity)this.entity)) {
            return false;
        }
        if (this.field_179496_a > 0) {
            --this.field_179496_a;
            return false;
        }
        if (this.func_220729_m()) {
            this.field_179496_a = 20;
            return true;
        }
        this.field_179496_a = this.func_203109_a(this.field_179495_c);
        return false;
    }

    private boolean func_220729_m() {
        return this.field_179494_b != null && this.func_179488_a((IWorldReader)this.field_179495_c.field_70170_p, this.field_179494_b) ? true : this.func_179489_g();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.entity.field_70143_R = 1.0f;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.breakingTime = 0;
    }

    protected int getBreakTime(MobEntity entity) {
        return 60;
    }

    public void playBreakingSound(IWorld worldIn, BlockPos pos) {
    }

    public void playBrokenSound(World worldIn, BlockPos pos) {
    }

    public boolean func_75253_b() {
        if (this.entity instanceof PVZZombieEntity && !((PVZZombieEntity)this.entity).checkCanZombieBreakBlock()) {
            return false;
        }
        return super.func_75253_b();
    }

    public void func_75246_d() {
        super.func_75246_d();
        World world = this.entity.field_70170_p;
        if (this.isEntityNearBy() && this.field_179494_b != null) {
            if (this.breakingTime % 2 == 0 && this.breakingTime % 6 == 0) {
                this.playBreakingSound((IWorld)world, this.field_179494_b);
            }
            if (this.breakingTime > this.getBreakTime(this.entity)) {
                world.func_175655_b(this.field_179494_b, false);
                if (!world.field_72995_K) {
                    this.playBrokenSound(world, this.field_179494_b);
                }
            }
            this.entity.field_70170_p.func_175715_c(this.entity.func_145782_y(), this.field_179494_b, this.breakingTime / 8);
            ++this.breakingTime;
        }
    }

    protected boolean isEntityNearBy() {
        double zz;
        if (Math.abs((double)this.field_179494_b.func_177956_o() - this.entity.func_226278_cu_()) > 3.0) {
            return false;
        }
        double x = this.field_179494_b.func_177958_n();
        double z = this.field_179494_b.func_177952_p();
        double xx = this.entity.func_226277_ct_();
        return (x - xx) * (x - xx) + (z - (zz = this.entity.func_226281_cx_())) * (z - zz) <= 4.0;
    }

    @Nullable
    private BlockPos findTarget(BlockPos pos, IBlockReader worldIn) {
        BlockPos[] ablockpos;
        if (worldIn.func_180495_p(pos).func_177230_c() == this.block) {
            return pos;
        }
        for (BlockPos blockpos : ablockpos = new BlockPos[]{pos.func_177977_b(), pos.func_177976_e(), pos.func_177974_f(), pos.func_177978_c(), pos.func_177968_d(), pos.func_177977_b().func_177977_b()}) {
            if (worldIn.func_180495_p(blockpos).func_177230_c() != this.block) continue;
            return blockpos;
        }
        return null;
    }

    protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
        IChunk ichunk = worldIn.func_217353_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, ChunkStatus.field_222617_m, false);
        if (ichunk == null) {
            return false;
        }
        return ichunk.func_180495_p(pos).func_177230_c() == this.block && ichunk.func_180495_p(pos.func_177984_a()).func_196958_f() && ichunk.func_180495_p(pos.func_177981_b(2)).func_196958_f();
    }
}

