/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.bullet;

import com.hungteen.pvz.entity.misc.AbstractOwnerEntity;
import com.hungteen.pvz.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.interfaces.IGroupEntity;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractBulletEntity
extends AbstractOwnerEntity
implements IProjectile,
IGroupEntity {
    protected IntOpenHashSet hitEntities;
    protected float airSlowDown = 0.99f;
    protected float attackDamage = 0.0f;

    public AbstractBulletEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
    }

    public AbstractBulletEntity(EntityType<?> type, World worldIn, LivingEntity livingEntityIn) {
        super(type, worldIn, livingEntityIn);
        this.attackDamage = this.getAttackDamage();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public void func_70071_h_() {
        float f1;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa >= this.getMaxLiveTick()) {
            this.func_70106_y();
        }
        if (this.field_70173_aa <= 10) {
            this.func_213323_x_();
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityRayTraceResult entityRay;
            Vec3d end;
            Vec3d start = this.func_213303_ch();
            BlockRayTraceResult result = this.field_70170_p.func_217299_a(new RayTraceContext(start, end = start.func_178787_e(this.func_213322_ci()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (result.func_216346_c() != RayTraceResult.Type.MISS) {
                end = result.func_216347_e();
            }
            if ((entityRay = this.rayTraceEntities(start, end)) != null) {
                result = entityRay;
            }
            if (result != null && result.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)result)) {
                this.onImpact((RayTraceResult)result);
            }
        }
        Vec3d vec3d = this.func_213322_ci();
        double d0 = this.func_226277_ct_() + vec3d.field_72450_a;
        double d1 = this.func_226278_cu_() + vec3d.field_72448_b;
        double d2 = this.func_226281_cx_() + vec3d.field_72449_c;
        float f = MathHelper.func_76133_a((double)AbstractBulletEntity.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d0 - vec3d.field_72450_a * 0.25, d1 - vec3d.field_72448_b * 0.25, d2 - vec3d.field_72449_c * 0.25, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            }
            f1 = 0.8f;
        } else {
            f1 = this.airSlowDown;
        }
        this.func_213317_d(vec3d.func_186678_a((double)f1));
        if (!this.func_189652_ae()) {
            Vec3d vec3d1 = this.func_213322_ci();
            this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b - (double)this.getGravityVelocity(), vec3d1.field_72449_c);
        }
        this.func_70107_b(d0, d1, d2);
    }

    protected void addHitEntity(Entity entity) {
        this.hitEntities.addAll(EntityUtil.getOwnerAndPartsID(entity));
    }

    protected boolean checkCanAttack(Entity target) {
        return EntityUtil.checkCanEntityAttack(this, target);
    }

    protected boolean shouldHit(Entity target) {
        return EntityUtil.checkCanEntityAttack(this, target);
    }

    public void shootPea(double dx, double dy, double dz, double speed) {
        double down = this.getShootPeaAngle();
        double dxz = Math.sqrt(dx * dx + dz * dz);
        dy = MathHelper.func_151237_a((double)dy, (double)(-dxz / down), (double)(dxz / down));
        double dis = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double vx = dx / dis * speed;
        double vy = dy / dis * speed;
        double vz = dz / dis * speed;
        this.func_213293_j(vx, vy, vz);
    }

    public void shootPeaAnti(double dx, double dy, double dz, double speed) {
        double down = this.getShootPeaAngle();
        double dxz = Math.sqrt(dx * dx + dz * dz);
        dy = MathHelper.func_151237_a((double)dy, (double)(-dxz / down), (double)(dxz / down));
        double dis = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double vx = dx / dis * speed;
        double vy = dy / dis * speed;
        double vz = dz / dis * speed;
        this.func_213293_j(-vx, -vy, -vz);
    }

    public void shootToTarget(LivingEntity target, double speed) {
        this.func_213317_d(target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e(), 0.0).func_178788_d(this.func_213303_ch()).func_72432_b().func_186678_a(speed));
    }

    protected double getShootPeaAngle() {
        if (this.getThrower() instanceof PlantShooterEntity) {
            return ((PlantShooterEntity)this.getThrower()).getMaxShootAngle();
        }
        return 10.0;
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vec3d startVec, Vec3d endVec) {
        return ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)startVec, (Vec3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), entity -> entity.func_70067_L() && this.shouldHit((Entity)entity) && (this.hitEntities == null || !this.hitEntities.contains(entity.func_145782_y())));
    }

    @Override
    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected abstract void onImpact(RayTraceResult var1);

    protected abstract float getAttackDamage();

    @Nullable
    public LivingEntity getThrower() {
        return this.getOwner();
    }

    protected abstract int getMaxLiveTick();

    protected boolean checkLive(RayTraceResult result) {
        Block block;
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            return !EntityUtil.checkCanEntityAttack((Entity)this.getThrower(), ((EntityRayTraceResult)result).func_216348_a());
        }
        return result.func_216346_c() == RayTraceResult.Type.BLOCK && (block = this.field_70170_p.func_180495_p(((BlockRayTraceResult)result).func_216350_a()).func_177230_c()) instanceof BushBlock;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("bullet_attack_damage")) {
            this.attackDamage = compound.func_74760_g("bullet_attack_damage");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("bullet_attack_damage", this.attackDamage);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

