/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.bullet;

import com.hungteen.pvz.advancement.trigger.EntityEffectAmountTrigger;
import com.hungteen.pvz.entity.bullet.PultBulletEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.plant.explosion.CobCannonEntity;
import com.hungteen.pvz.entity.zombie.roof.GargantuarEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class CornEntity
extends PultBulletEntity {
    public int cornCnt;

    public CornEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
        this.height = 20.0f;
    }

    public CornEntity(World worldIn, LivingEntity living) {
        super((EntityType)EntityRegister.CORN.get(), worldIn, living);
        this.height = 20.0f;
    }

    @Override
    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
    }

    @Override
    protected void dealDamage(Entity target) {
        this.dealExplosionDamage();
    }

    @Override
    protected void onHitBlock() {
        this.dealExplosionDamage();
    }

    private void dealExplosionDamage() {
        int i;
        PlayerEntity player;
        EntityUtil.playSound(this, (SoundEvent)SoundRegister.CHERRY_BOMB.get());
        float range = 2.8f;
        int killCnt = 0;
        for (Entity entity : EntityUtil.getAttackEntities(this, EntityUtil.getEntityAABB(this, range, range))) {
            if (entity instanceof LivingEntity && !EntityUtil.checkCanEntityTarget((Entity)this.getThrower(), (LivingEntity)entity)) continue;
            entity.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage(this, (Entity)this.getThrower()), this.attackDamage);
            if (EntityUtil.isEntityValid(entity) || !(entity instanceof GargantuarEntity)) continue;
            ++killCnt;
        }
        if (this.getThrower() instanceof PVZPlantEntity && (player = EntityUtil.getEntityOwner(this.field_70170_p, (Entity)this.getThrower())) != null && player instanceof ServerPlayerEntity) {
            EntityEffectAmountTrigger.INSTANCE.trigger((ServerPlayerEntity)player, (Entity)this.getThrower(), killCnt);
        }
        ItemEntity item = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), new ItemStack((IItemProvider)ItemRegister.POP_CORN.get(), this.cornCnt));
        item.func_174869_p();
        this.field_70170_p.func_217376_c((Entity)item);
        this.cornCnt = 0;
        for (i = 0; i < 3; ++i) {
            EntityUtil.spawnParticle(this, 8);
        }
        for (i = 0; i < 20; ++i) {
            EntityUtil.spawnParticle(this, 9);
        }
    }

    @Override
    protected float getAttackDamage() {
        if (this.getThrower() instanceof CobCannonEntity) {
            return ((CobCannonEntity)this.getThrower()).getAttackDamage();
        }
        return 0.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)1.0f, (float)1.0f);
    }

    @Override
    protected int getMaxLiveTick() {
        return 300;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("cannon_pop_corn_cnt")) {
            this.cornCnt = compound.func_74762_e("cannon_pop_corn_cnt");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("cannon_pop_corn_cnt", this.cornCnt);
    }
}

