/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.bullet.itembullet;

import com.hungteen.pvz.entity.bullet.PultBulletEntity;
import com.hungteen.pvz.entity.plant.arma.CabbagePultEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.ItemRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class CabbageEntity
extends PultBulletEntity
implements IRendersAsItem {
    private static final DataParameter<Integer> CABBAGE_TYPE = EntityDataManager.func_187226_a(CabbageEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public CabbageEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
    }

    public CabbageEntity(World worldIn, LivingEntity shooter) {
        super((EntityType)EntityRegister.CABBAGE.get(), worldIn, shooter);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CABBAGE_TYPE, (Object)CabbageTypes.NORMAL.ordinal());
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)ItemRegister.CABBAGE.get());
    }

    @Override
    protected void dealDamage(Entity target) {
        target.func_70097_a((DamageSource)PVZDamageSource.causeThrowDamage(this, (Entity)this.getThrower()), this.getFixDamage());
    }

    private float getFixDamage() {
        float damage = this.attackDamage;
        if (this.getCabbageType() == CabbageTypes.POWER) {
            damage += 20.0f;
        }
        return damage;
    }

    @Override
    protected float getAttackDamage() {
        if (this.getThrower() instanceof CabbagePultEntity) {
            return ((CabbagePultEntity)this.getThrower()).getAttackDamage();
        }
        return 0.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.5f, (float)0.5f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("cabbage_type")) {
            this.setCabbageType(CabbageTypes.values()[compound.func_74762_e("cabbage_type")]);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("cabbage_type", this.getCabbageType().ordinal());
    }

    public void setCabbageType(CabbageTypes type) {
        this.field_70180_af.func_187227_b(CABBAGE_TYPE, (Object)type.ordinal());
    }

    public CabbageTypes getCabbageType() {
        return CabbageTypes.values()[(Integer)this.field_70180_af.func_187225_a(CABBAGE_TYPE)];
    }

    public static enum CabbageTypes {
        NORMAL,
        POWER;

    }
}

