/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.bullet.itembullet;

import com.hungteen.pvz.entity.bullet.itembullet.PVZItemBulletEntity;
import com.hungteen.pvz.entity.plant.explosion.BambooLordEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class FireCrackerEntity
extends PVZItemBulletEntity {
    private static final float SPEED = 1.5f;
    protected Entity target = null;

    public FireCrackerEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
    }

    public FireCrackerEntity(World worldIn, LivingEntity owner) {
        super((EntityType)EntityRegister.FIRE_CRACKER.get(), worldIn, owner);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && EntityUtil.isEntityValid(this.target)) {
            this.shoot(this.target);
        }
    }

    public void shoot(Vec3d vec) {
        this.func_213317_d(vec.func_186678_a(1.5));
    }

    public void shoot(Entity target) {
        this.target = target;
        Vec3d vec = target.func_213303_ch().func_178788_d(this.func_213303_ch()).func_72432_b();
        this.shoot(vec);
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        Entity target;
        boolean flag = false;
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY && this.checkCanAttack(target = ((EntityRayTraceResult)result).func_216348_a())) {
            target.field_70172_ad = 0;
            this.dealDamage(target);
            flag = true;
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        if (flag) {
            this.func_70106_y();
        } else if (!this.checkLive(result)) {
            this.dealDamage(null);
            this.func_70106_y();
        }
    }

    private void dealDamage(Entity target) {
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.playSound(this, (SoundEvent)SoundRegister.POTATO_MINE.get());
            float range = 1.5f;
            EntityUtil.getAttackEntities(this, EntityUtil.getEntityAABB(this, range, range)).forEach(entity -> entity.func_70097_a((DamageSource)PVZDamageSource.causeExplosionDamage(this, (Entity)this.getThrower()), this.attackDamage));
            for (int i = 0; i < 3; ++i) {
                EntityUtil.spawnParticle(this, 5);
            }
        }
    }

    @Override
    protected float getAttackDamage() {
        if (this.getThrower() instanceof BambooLordEntity) {
            return ((BambooLordEntity)this.getThrower()).getAttackDamage() * 2.0f;
        }
        if (this.getThrower() instanceof PlayerEntity) {
            return 3.0f;
        }
        return 0.0f;
    }

    @Override
    protected int getMaxLiveTick() {
        return 50;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("target_entity_id")) {
            this.target = this.field_70170_p.func_73045_a(compound.func_74762_e("target_entity_id"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.target != null) {
            compound.func_74768_a("target_entity_id", this.target.func_145782_y());
        }
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)ItemRegister.FIRE_CRACKER.get());
    }

    public boolean func_189652_ae() {
        return true;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.5f, (float)0.5f);
    }
}

