/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.drop;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.entity.drop.DropEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Resources;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class CoinEntity
extends DropEntity {
    public static final int COIN_TYPES = 3;

    public CoinEntity(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
        this.setAmountByType(this.getRandomType());
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.COIN_DROP.get());
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            PlayerUtil.addPlayerStats(entityIn, Resources.MONEY, this.getAmount());
        } else {
            EntityUtil.playSound((Entity)entityIn, (SoundEvent)SoundRegister.COIN_PICK.get());
        }
        this.func_70106_y();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        float t = (float)Math.log10(this.getAmount());
        float w = t * 0.18f + 0.4f;
        return new EntitySize(w, w, false);
    }

    public void setAmountByType(CoinType type) {
        this.setAmount(type.money);
    }

    protected CoinType getRandomType() {
        return CoinType.values()[this.field_70146_Z.nextInt(3)];
    }

    @Override
    protected int getMaxLiveTick() {
        return (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.EntityLiveTick.CoinLiveTick.get();
    }

    public static enum CoinType {
        COPPER(1),
        SILVER(10),
        GOLD(100);

        public final int money;

        private CoinType(int money) {
            this.money = money;
        }
    }
}

