/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.misc;

import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.interfaces.IGroupEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractOwnerEntity
extends Entity
implements IGroupEntity {
    protected LivingEntity owner;
    protected UUID ownerId;
    protected int groupType;

    public AbstractOwnerEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.groupType = this.getInitialEntityGroup();
    }

    public AbstractOwnerEntity(EntityType<?> type, World worldIn, LivingEntity livingEntityIn) {
        super(type, worldIn);
        this.owner = livingEntityIn;
        this.ownerId = livingEntityIn.func_110124_au();
        this.groupType = EntityUtil.getEntityGroup((Entity)this.owner);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa <= 10) {
            this.func_213323_x_();
        }
    }

    protected void tickMove() {
        float f1;
        Vec3d vec3d = this.func_213322_ci();
        double d0 = this.func_226277_ct_() + vec3d.field_72450_a;
        double d1 = this.func_226278_cu_() + vec3d.field_72448_b;
        double d2 = this.func_226281_cx_() + vec3d.field_72449_c;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d0 - vec3d.field_72450_a * 0.25, d1 - vec3d.field_72448_b * 0.25, d2 - vec3d.field_72449_c * 0.25, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            }
            f1 = 0.8f;
        } else {
            f1 = 1.0f;
        }
        this.func_213317_d(vec3d.func_186678_a((double)f1));
        if (!this.func_189652_ae()) {
            Vec3d vec3d1 = this.func_213322_ci();
            this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b - (double)this.getGravityVelocity(), vec3d1.field_72449_c);
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    protected float getGravityVelocity() {
        return 0.05f;
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setOwner(LivingEntity player) {
        this.owner = player;
    }

    @Nullable
    public LivingEntity getOwner() {
        if ((this.owner == null || !this.owner.func_70089_S()) && this.ownerId != null && this.field_70170_p instanceof ServerWorld) {
            Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerId);
            this.owner = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        }
        return this.owner;
    }

    public int getInitialEntityGroup() {
        return 1;
    }

    @Override
    public int getEntityGroupType() {
        return this.groupType;
    }

    public void func_213281_b(CompoundNBT compound) {
        if (this.ownerId != null) {
            compound.func_218657_a("owner", (INBT)NBTUtil.func_186862_a((UUID)this.ownerId));
        }
        compound.func_74768_a("entity_tick_exist", this.field_70173_aa);
        compound.func_74768_a("group_owner_type", this.groupType);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.owner = null;
        if (compound.func_150297_b("owner", 10)) {
            this.ownerId = NBTUtil.func_186860_b((CompoundNBT)compound.func_74775_l("owner"));
        }
        if (compound.func_74764_b("entity_tick_exist")) {
            this.field_70173_aa = compound.func_74762_e("entity_tick_exist");
        }
        if (compound.func_74764_b("group_owner_type")) {
            this.groupType = compound.func_74762_e("group_owner_type");
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

