/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.misc;

import com.hungteen.pvz.entity.misc.AbstractOwnerEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GardenRakeEntity
extends AbstractOwnerEntity {
    private static final DataParameter<Integer> ATTACK_TIME = EntityDataManager.func_187226_a(GardenRakeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public GardenRakeEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_213317_d(Vec3d.field_186680_a);
    }

    public GardenRakeEntity(World worldIn, LivingEntity livingEntityIn) {
        super((EntityType)EntityRegister.GARDEN_RAKE.get(), worldIn, livingEntityIn);
        this.field_70177_z = livingEntityIn.func_174811_aO().func_185119_l();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_TIME, (Object)0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.isStartAttack()) {
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.getAttackTime() >= this.getAnimTime()) {
                    this.dealDamage();
                }
            } else {
                List list = this.field_70170_p.func_175647_a(Entity.class, this.func_174813_aQ().func_186662_g(0.2), target -> EntityUtil.checkCanEntityAttack(this, target));
                if (!list.isEmpty()) {
                    this.onStartAttack();
                }
            }
        }
        this.tickMove();
    }

    private void dealDamage() {
        this.field_70170_p.func_175647_a(Entity.class, this.func_174813_aQ().func_186662_g(0.25), target -> EntityUtil.checkCanEntityAttack(this, target)).forEach(target -> target.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage(this, this), 180.0f));
        EntityUtil.playSound(this, (SoundEvent)SoundRegister.SWING.get());
        this.func_70106_y();
    }

    protected void onStartAttack() {
        this.setAttackTime(1);
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.isStartAttack() && hand == Hand.MAIN_HAND && player.func_184614_ca().func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_191521_c(new ItemStack((IItemProvider)ItemRegister.GARDEN_RAKE.get()));
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean isStartAttack() {
        return this.getAttackTime() > 0;
    }

    public int getAnimTime() {
        return 10;
    }

    public void setPlacer(PlayerEntity player) {
        this.setOwner((LivingEntity)player);
        this.field_70177_z = player.func_174811_aO().func_185119_l();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.9f, (float)0.8f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("rake_attack_time")) {
            this.setAttackTime(compound.func_74762_e("rake_attack_time"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("rake_attack_time", this.getAttackTime());
    }

    public int getAttackTime() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TIME);
    }

    public void setAttackTime(int cd) {
        this.field_70180_af.func_187227_b(ATTACK_TIME, (Object)cd);
    }
}

