/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.misc.bowling;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.entity.misc.AbstractOwnerEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractBowlingEntity
extends AbstractOwnerEntity {
    protected IntOpenHashSet hitEntities;
    private static final DataParameter<Integer> FACING = EntityDataManager.func_187226_a(AbstractBowlingEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DIRECTION = EntityDataManager.func_187226_a(AbstractBowlingEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int bowlingTick = 0;
    private int wallTick = 0;
    private boolean playSpawnSound = false;
    protected int hitCount = 0;

    public AbstractBowlingEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
        this.field_70144_Y = 1.0f;
    }

    public AbstractBowlingEntity(EntityType<?> type, World worldIn, PlayerEntity livingEntityIn) {
        this(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FACING, (Object)BowlingFacings.MID.ordinal());
        this.field_70180_af.func_187214_a(DIRECTION, (Object)Direction.NORTH.ordinal());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa <= 10 && !this.playSpawnSound) {
                EntityUtil.playSound(this, (SoundEvent)SoundRegister.BOWLING_SPAWN.get());
                this.playSpawnSound = true;
            }
            if (this.field_70173_aa >= this.getMaxLiveTick()) {
                this.func_70106_y();
            }
        }
        this.field_70126_B = this.field_70177_z;
        this.field_70177_z = this.getDirection().func_185119_l() + this.getBowlingFacing().offset;
        double angle = (double)this.field_70177_z * Math.PI / 180.0;
        double dx = -Math.sin(angle);
        double dz = Math.cos(angle);
        double speed = this.getBowlingSpeed();
        this.func_213293_j(dx * speed, this.func_213322_ci().func_82617_b(), dz * speed);
        this.tickRayTrace();
        this.tickMove();
        this.tickCollision();
        if (!this.field_70170_p.field_72995_K) {
            if (this.bowlingTick > 0) {
                --this.bowlingTick;
            }
            if (this.wallTick > 0) {
                --this.wallTick;
            }
            if (this.bowlingTick == 0 && this.field_70123_F) {
                if (this.wallTick > 0) {
                    this.func_70106_y();
                } else {
                    this.wallTick = 15;
                    this.changeDiretion();
                }
            }
        }
    }

    protected void tickCollision() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.bowlingTick > 0) {
            return;
        }
        List list = this.field_70170_p.func_175647_a(Entity.class, this.func_174813_aQ(), target -> EntityUtil.checkCanEntityAttack(this, target));
        if (!list.isEmpty()) {
            this.dealDamageTo((Entity)list.get(0));
            this.changeDiretion();
        }
    }

    private void tickRayTrace() {
        EntityRayTraceResult entityRay;
        Vec3d end;
        double rayLen = 3.0;
        double angle = (double)(this.getDirection().func_185119_l() + this.getBowlingFacing().offset) * Math.PI / 180.0;
        double dx = Math.sin(angle);
        double dz = -Math.cos(angle);
        Vec3d start = this.func_213303_ch();
        BlockRayTraceResult result = this.field_70170_p.func_217299_a(new RayTraceContext(start, end = start.func_178787_e(new Vec3d(dx * rayLen, 0.0, dz * rayLen)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (result.func_216346_c() != RayTraceResult.Type.MISS) {
            end = result.func_216347_e();
        }
        if ((entityRay = this.rayTraceEntities(start, end)) != null) {
            result = entityRay;
        }
        if (result != null && result.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)result)) {
            this.onImpact((RayTraceResult)result);
        }
    }

    protected void changeDiretion() {
        if (this.getBowlingFacing() == BowlingFacings.MID) {
            this.setBowlingFacing(this.field_70146_Z.nextInt(2) == 0 ? BowlingFacings.LEFT : BowlingFacings.RIGHT);
        } else if (this.getBowlingFacing() == BowlingFacings.LEFT) {
            this.setBowlingFacing(BowlingFacings.RIGHT);
        } else if (this.getBowlingFacing() == BowlingFacings.RIGHT) {
            this.setBowlingFacing(BowlingFacings.LEFT);
        }
        this.bowlingTick = 10;
    }

    protected abstract void dealDamageTo(Entity var1);

    public void shoot(PlayerEntity player) {
        Direction direction = player.func_174811_aO();
        this.setDirection(direction);
        this.field_70177_z = direction.func_185119_l();
    }

    public double getBowlingSpeed() {
        return 0.3;
    }

    protected void addHitEntity(Entity entity) {
        this.hitEntities.addAll(EntityUtil.getOwnerAndPartsID(entity));
    }

    protected boolean shouldHit(Entity target) {
        return EntityUtil.checkCanEntityAttack((Entity)this.getOwner(), target);
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vec3d startVec, Vec3d endVec) {
        return ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)startVec, (Vec3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), entity -> entity.func_70067_L() && this.shouldHit((Entity)entity) && (this.hitEntities == null || !this.hitEntities.contains(entity.func_145782_y())));
    }

    protected void onImpact(RayTraceResult result) {
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.95f, (float)1.0f);
    }

    protected int getMaxLiveTick() {
        return (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.EntityLiveTick.BowlingLiveTick.get();
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("bowling_facings", this.getBowlingFacing().ordinal());
        compound.func_74768_a("bowling_directions", this.getDirection().ordinal());
        compound.func_74768_a("bowling_tick", this.bowlingTick);
        compound.func_74768_a("bowling_hit_count", this.hitCount);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("bowling_facings")) {
            this.setBowlingFacing(BowlingFacings.values()[compound.func_74762_e("bowling_facings")]);
        }
        if (compound.func_74764_b("bowling_directions")) {
            this.setDirection(Direction.values()[compound.func_74762_e("bowling_directions")]);
        }
        if (compound.func_74764_b("bowling_tick")) {
            this.bowlingTick = compound.func_74762_e("bowling_tick");
        }
        if (compound.func_74764_b("bowling_hit_count")) {
            this.hitCount = compound.func_74762_e("bowling_hit_count");
        }
    }

    public Direction getDirection() {
        return Direction.values()[(Integer)this.field_70180_af.func_187225_a(DIRECTION)];
    }

    public void setDirection(Direction drt) {
        this.field_70180_af.func_187227_b(DIRECTION, (Object)drt.ordinal());
    }

    public BowlingFacings getBowlingFacing() {
        return BowlingFacings.values()[(Integer)this.field_70180_af.func_187225_a(FACING)];
    }

    public void setBowlingFacing(BowlingFacings facing) {
        this.field_70180_af.func_187227_b(FACING, (Object)facing.ordinal());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    public static enum BowlingFacings {
        LEFT(-45.0f),
        MID(0.0f),
        RIGHT(45.0f),
        BOMB(0.0f);

        public final float offset;

        private BowlingFacings(float offset) {
            this.offset = offset;
        }
    }
}

