/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.advancement.trigger.PlantSuperTrigger;
import com.hungteen.pvz.entity.ai.PVZLookRandomlyGoal;
import com.hungteen.pvz.entity.drop.SunEntity;
import com.hungteen.pvz.entity.plant.enforce.SquashEntity;
import com.hungteen.pvz.entity.plant.light.GoldLeafEntity;
import com.hungteen.pvz.entity.plant.spear.SpikeWeedEntity;
import com.hungteen.pvz.entity.zombie.grassnight.TombStoneEntity;
import com.hungteen.pvz.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.entity.zombie.poolnight.DiggerZombieEntity;
import com.hungteen.pvz.entity.zombie.roof.BungeeZombieEntity;
import com.hungteen.pvz.item.tool.card.ImitaterCardItem;
import com.hungteen.pvz.item.tool.card.PlantCardItem;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.misc.damage.PVZDamageType;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Essences;
import com.hungteen.pvz.utils.enums.MetalTypes;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Ranks;
import com.hungteen.pvz.utils.interfaces.IHasMetal;
import com.hungteen.pvz.utils.interfaces.IPVZPlant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class PVZPlantEntity
extends CreatureEntity
implements IPVZPlant,
IHasMetal {
    private static final DataParameter<Integer> SUPER_TIME = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PLANT_LVL = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> PLANT_STATES = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ATTACK_TIME = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GOLD_TIME = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_CHARMED = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SLEEP_TIME = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LIVE_TICK = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> PUMPKIN_LIFE = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final int LADDER_FLAG = 0;
    protected int weakTime = 0;
    protected boolean isImmuneToWeak = false;
    private final int weakCD = 10;
    private final int weakDamage = 15;
    protected Optional<Plants> outerPlant = Optional.empty();
    public boolean canCollideWithPlant = true;
    protected boolean canBeCharmed = true;
    public int plantSunCost = 0;
    public int outerSunCost = 0;

    public PVZPlantEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_213323_x_();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUPER_TIME, (Object)0);
        this.field_70180_af.func_187214_a(PLANT_LVL, (Object)1);
        this.field_70180_af.func_187214_a(OWNER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(ATTACK_TIME, (Object)0);
        this.field_70180_af.func_187214_a(GOLD_TIME, (Object)0);
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
        this.field_70180_af.func_187214_a(IS_CHARMED, (Object)false);
        this.field_70180_af.func_187214_a(SLEEP_TIME, (Object)0);
        this.field_70180_af.func_187214_a(LIVE_TICK, (Object)0);
        this.field_70180_af.func_187214_a(PUMPKIN_LIFE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PLANT_STATES, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new PVZLookRandomlyGoal((MobEntity)this));
    }

    public void onSpawnedByPlayer(PlayerEntity player, int lvl) {
        this.setPlantLvl(lvl);
        this.setOwnerUUID(player.func_110124_au());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getPlantHealth());
        this.func_70691_i(this.func_110138_aP());
    }

    @Override
    public float getPlantHealth() {
        int lvl = this.getPlantLvl();
        if (lvl <= 14) {
            return 27.5f + 2.5f * (float)lvl;
        }
        return 5 * lvl - 10;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_70089_S()) {
            return;
        }
        this.plantBaseTick();
        if (this.canPlantNormalUpdate()) {
            this.normalPlantTick();
        }
    }

    public boolean canPlantNormalUpdate() {
        if (this.func_184187_bx() instanceof BungeeZombieEntity || this.hasMetal()) {
            return false;
        }
        return !this.isPlantSleeping() && !EntityUtil.isEntityFrozen((LivingEntity)this) && !EntityUtil.isEntityButter((LivingEntity)this);
    }

    protected void plantBaseTick() {
        if (!this.field_70170_p.field_72995_K && !this.isImmuneToWeak && this.func_184187_bx() == null) {
            if (this.checkNormalPlantWeak() && this.weakTime == 0) {
                this.weakTime = this.weakCD;
                PVZDamageSource pVZDamageSource = PVZDamageSource.causeWeakDamage((Entity)this, (Entity)this);
                this.getClass();
                this.func_70097_a(pVZDamageSource, 15.0f);
            }
            if (this.weakTime > 0) {
                --this.weakTime;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getSuperTime() > 0) {
                this.setSuperTime(this.getSuperTime() - 1);
            }
            if (this.getBoostTime() > 0) {
                this.setBoostTime(this.getBoostTime() - 1);
            }
            if (this.shouldPlantRegularSleep()) {
                if (this.getSleepTime() < 0) {
                    this.setSleepTime(this.getSleepTime() + 1);
                } else {
                    this.setSleepTime(Math.max(1, this.getSleepTime()));
                }
            } else if (this.getSleepTime() > 0) {
                this.setSleepTime(this.getSleepTime() - 1);
            }
        }
        if (this.field_70170_p.field_72995_K && this.isPlantSleeping() && this.field_70173_aa % 20 == 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.SLEEP.get(), this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_(), 0.05, 0.05, 0.05);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setLiveTick(this.getLiveTick() + 1);
            if (this.getLiveTick() >= this.getMaxLiveTick()) {
                this.func_70106_y();
            }
        }
        if (this.shouldLockXZ() && this.func_184187_bx() == null) {
            BlockPos pos = this.func_180425_c();
            this.func_70107_b((double)pos.func_177958_n() + 0.5, this.func_226278_cu_(), (double)pos.func_177952_p() + 0.5);
        }
        if (!this.field_70170_p.field_72995_K && this.getPlantEnumName().isWaterPlant && this.func_70090_H()) {
            Vec3d vec = this.func_213322_ci();
            double speedY = Math.min(vec.field_72448_b, 0.05);
            this.func_213293_j(vec.field_72450_a, speedY, vec.field_72449_c);
        }
    }

    protected void normalPlantTick() {
        if (!this.field_70170_p.field_72995_K && this.getGoldTime() < 400) {
            Block block = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c();
            int lvl = GoldLeafEntity.getBlockGoldLevel(block);
            if (lvl <= 0) {
                return;
            }
            this.setGoldTime(this.getGoldTime() + 1);
            if (this.getGoldTime() >= 400) {
                this.setGoldTime(0);
                SunEntity sun = (SunEntity)((EntityType)EntityRegister.SUN.get()).func_200721_a(this.field_70170_p);
                sun.setAmount(GoldLeafEntity.getGoldGenAmount(lvl));
                EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, sun, this.func_180425_c(), 2);
                EntityUtil.playSound((Entity)this, SoundEvents.field_187604_bf);
            }
        }
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!worldIn.func_201670_d()) {
            EntityUtil.playSound((Entity)this, this.getSpawnSound());
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getPlantHealth());
            this.func_70691_i(this.func_110138_aP());
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected boolean checkNormalPlantWeak() {
        double y2;
        if (this.isImmuneToWeak || this.func_184187_bx() != null) {
            return false;
        }
        if (this.getPlantEnumName().isWaterPlant) {
            return this.field_70122_E && !this.func_70090_H() && this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() != Blocks.field_150355_j;
        }
        if (!this.field_70122_E) {
            return false;
        }
        if (this.func_70090_H()) {
            return true;
        }
        double y1 = this.func_226278_cu_();
        BlockPos pos = Math.abs(y1 - (y2 = (double)MathHelper.func_76128_c((double)y1))) <= 0.01 ? this.func_180425_c().func_177977_b() : this.func_180425_c();
        Block current = this.field_70170_p.func_180495_p(pos).func_177230_c();
        return !PlantUtil.getPlantSuitBlock(this.getPlantEnumName()).stream().anyMatch(block -> block == current);
    }

    public boolean checkCanPlantTarget(LivingEntity entity) {
        return EntityUtil.checkCanEntityAttack((Entity)this, (Entity)entity) && this.canPlantTarget(entity);
    }

    protected boolean canPlantTarget(LivingEntity entity) {
        if (entity instanceof DiggerZombieEntity) {
            return ((DiggerZombieEntity)entity).getAnimTime() == 30;
        }
        if (entity instanceof BalloonZombieEntity) {
            return !((BalloonZombieEntity)entity).hasBalloon();
        }
        if (entity instanceof BungeeZombieEntity) {
            return ((BungeeZombieEntity)entity).getBungeeState() == BungeeZombieEntity.BungeeStates.CATCH;
        }
        return true;
    }

    protected boolean shouldPlantRegularSleep() {
        if (this.getPlantEnumName().isShroomPlant) {
            return this.field_70170_p.func_72935_r();
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof PVZDamageSource) {
            this.field_70172_ad = 0;
        }
        amount = this.pumpkinReduceDamage(source, amount);
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        entityIn.field_70172_ad = 0;
        return super.func_70652_k(entityIn);
    }

    protected boolean shouldLockXZ() {
        return true;
    }

    public void func_70108_f(Entity entityIn) {
        if (!(this.func_184223_x(entityIn) || entityIn.field_70145_X || this.field_70145_X)) {
            double d1;
            double d0 = entityIn.func_226277_ct_() - this.func_226277_ct_();
            double d2 = MathHelper.func_76132_a((double)d0, (double)(d1 = entityIn.func_226281_cx_() - this.func_226281_cx_()));
            if (d2 >= (double)0.01f) {
                d2 = MathHelper.func_76133_a((double)d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.05f;
                d1 *= (double)0.05f;
                d0 *= (double)(1.0f - this.field_70144_Y);
                d1 *= (double)(1.0f - this.field_70144_Y);
                if (!entityIn.func_184207_aI()) {
                    entityIn.func_70024_g(d0, 0.0, d1);
                }
            } else if (this instanceof PVZPlantEntity && entityIn instanceof PVZPlantEntity && !EntityUtil.checkCanEntityAttack((Entity)this, entityIn) && this.field_70173_aa >= entityIn.field_70173_aa) {
                this.func_70097_a(DamageSource.field_191291_g, 10.0f);
            }
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_96092_aw() {
        return !this.getPlantEnumName().isWaterPlant;
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ());
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_223592_c(GameRules.field_223616_s);
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (((Entity)list.get(k)).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                LivingEntity target = (LivingEntity)list.get(l);
                if (target == this || !this.shouldCollideWithEntity(target)) continue;
                this.func_82167_n((Entity)target);
            }
        }
    }

    protected boolean shouldCollideWithEntity(LivingEntity target) {
        if (target instanceof PVZPlantEntity) {
            if (!this.canCollideWithPlant || !((PVZPlantEntity)target).canCollideWithPlant) {
                return false;
            }
            if (target instanceof SquashEntity) {
                return !EntityUtil.checkCanEntityAttack((Entity)this, (Entity)target);
            }
            if (target instanceof SpikeWeedEntity) {
                return !EntityUtil.checkCanEntityAttack((Entity)this, (Entity)target);
            }
            return true;
        }
        if (target instanceof MobEntity) {
            if (((MobEntity)target).func_70638_az() == this) {
                return true;
            }
            if (target instanceof TombStoneEntity) {
                return true;
            }
        }
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.isPlantImmuneTo(source) && source != DamageSource.field_76380_i && !source.func_180136_u();
    }

    public boolean isPlantImmuneTo(DamageSource source) {
        return this.isPlantInSuperMode();
    }

    public boolean func_70648_aU() {
        return this.getPlantEnumName().isWaterPlant;
    }

    @Nullable
    public Plants getUpgradePlantType() {
        return null;
    }

    public void onPlantBeCharmed() {
        if (!this.canBeCharmed) {
            return;
        }
        this.setCharmed(!this.isCharmed());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("plant_weak_time", this.weakTime);
        compound.func_74768_a("plant_super_time", this.getSuperTime());
        compound.func_74768_a("plant_lvl", this.getPlantLvl());
        if (this.getOwnerUUID().isPresent()) {
            compound.func_74778_a("OwnerUUID", this.getOwnerUUID().get().toString());
        } else {
            compound.func_74778_a("OwnerUUID", "");
        }
        compound.func_74768_a("plant_attack_time", this.getAttackTime());
        compound.func_74768_a("plant_gold_time", this.getGoldTime());
        compound.func_74768_a("plant_boost_time", this.getBoostTime());
        compound.func_74757_a("is_plant_charmed", this.isCharmed());
        compound.func_74768_a("plant_sleep_time", this.getSleepTime());
        compound.func_74768_a("plant_live_tick", this.getLiveTick());
        this.outerPlant.ifPresent(plant -> compound.func_74768_a("outer_plant_type", plant.ordinal()));
        compound.func_74776_a("pumpkin_life", this.getPumpkinLife());
        compound.func_74768_a("plant_sun_cost", this.plantSunCost);
        compound.func_74768_a("outer_sun_cost", this.outerSunCost);
        compound.func_74757_a("immune_to_weak", this.isImmuneToWeak);
        compound.func_74768_a("plant_state", this.getPlantState());
    }

    public void func_70037_a(CompoundNBT compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_74764_b("plant_weak_time")) {
            this.weakTime = compound.func_74762_e("plant_weak_time");
        }
        if (compound.func_74764_b("plant_super_time")) {
            this.setSuperTime(compound.func_74762_e("plant_super_time"));
        }
        if (compound.func_74764_b("plant_lvl")) {
            this.setPlantLvl(compound.func_74762_e("plant_lvl"));
        }
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_74779_i("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerUUID(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (compound.func_74764_b("plant_attack_time")) {
            this.setAttackTime(compound.func_74762_e("plant_attack_time"));
        }
        if (compound.func_74764_b("plant_gold_time")) {
            this.setGoldTime(compound.func_74762_e("plant_gold_time"));
        }
        if (compound.func_74764_b("plant_boost_time")) {
            this.setBoostTime(compound.func_74762_e("plant_boost_time"));
        }
        if (compound.func_74764_b("is_plant_charmed")) {
            this.setCharmed(compound.func_74767_n("is_plant_charmed"));
        }
        if (compound.func_74764_b("plant_sleep_time")) {
            this.setSleepTime(compound.func_74762_e("plant_sleep_time"));
        }
        if (compound.func_74764_b("plant_live_tick")) {
            this.setLiveTick(compound.func_74762_e("plant_live_tick"));
        }
        if (compound.func_74764_b("pumpkin_life")) {
            this.setPumpkinLife(compound.func_74760_g("pumpkin_life"));
        }
        if (compound.func_74764_b("outer_plant_type")) {
            this.outerPlant = Optional.of(Plants.values()[compound.func_74762_e("outer_plant_type")]);
        }
        if (compound.func_74764_b("plant_sun_cost")) {
            this.plantSunCost = compound.func_74762_e("plant_sun_cost");
        }
        if (compound.func_74764_b("outer_sun_cost")) {
            this.outerSunCost = compound.func_74762_e("outer_sun_cost");
        }
        if (compound.func_74764_b("immune_to_weak")) {
            this.isImmuneToWeak = compound.func_74767_n("immune_to_weak");
        }
        if (compound.func_74764_b("plant_state")) {
            this.setPlantState(compound.func_74762_e("plant_state"));
        }
    }

    public void startSuperMode(boolean first) {
        this.setSuperTime(this.getSuperTimeLength());
        this.func_70691_i(this.func_110138_aP());
        this.setLiveTick(0);
        if (first) {
            PlayerEntity player = EntityUtil.getEntityOwner(this.field_70170_p, (Entity)this);
            if (player != null && player instanceof ServerPlayerEntity) {
                PlantSuperTrigger.INSTANCE.trigger((ServerPlayerEntity)player, (Entity)this);
                PlayerUtil.addPlantXp(player, this.getPlantEnumName(), 2);
            }
            this.outerPlant.ifPresent(plant -> {
                if (plant == Plants.PUMPKIN) {
                    this.setPumpkinLife(800.0f);
                }
            });
        }
    }

    protected float pumpkinReduceDamage(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && this.outerPlant.isPresent() && this.outerPlant.get() == Plants.PUMPKIN) {
            if (this.getPumpkinLife() > amount) {
                this.setPumpkinLife(this.getPumpkinLife() - amount);
                amount = 0.0f;
            } else {
                amount -= this.getPumpkinLife();
                this.setPumpkinLife(0.0f);
                this.outerPlant = Optional.empty();
            }
        }
        return amount;
    }

    public int getMaxLiveTick() {
        int tick = (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.EntityLiveTick.PlantLiveTick.get();
        return this.getPlantEnumName().isUpgradePlant ? 2 * tick : tick;
    }

    public boolean isPlantInSuperMode() {
        return this.getSuperTime() > 0;
    }

    public boolean canStartSuperMode() {
        return !this.isPlantSleeping() && this.hasSuperMode() && !this.isPlantInSuperMode();
    }

    private boolean hasSuperMode() {
        return this.getSuperTimeLength() > 0;
    }

    public boolean isPlantInBoost() {
        return this.getBoostTime() > 0;
    }

    @Override
    public int getCoolDownTime() {
        return PlantUtil.getPlantCoolDownTime(this.getPlantEnumName(), this.getPlantLvl());
    }

    @Override
    public int getSunCost() {
        return PlantUtil.getPlantSunCost(this.getPlantEnumName());
    }

    @Override
    public Essences getPlantEssenceType() {
        return PlantUtil.getPlantEssenceType(this.getPlantEnumName());
    }

    @Override
    public Ranks getPlantRank(Plants plant) {
        return PlantUtil.getPlantRankByName(plant);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isPlantSleeping() {
        return this.getSleepTime() > 0;
    }

    public void setOuterPlantType(Plants p) {
        this.outerPlant = Optional.of(p);
    }

    public Optional<Plants> getOuterPlantType() {
        return this.outerPlant;
    }

    public void setImmunneToWeak(boolean is) {
        this.isImmuneToWeak = is;
    }

    public void removeOuterPlant() {
        this.outerPlant = Optional.empty();
        this.setPumpkinLife(0.0f);
        this.outerSunCost = 0;
        if (this.hasMetal()) {
            this.decreaseMetal();
        }
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack stack;
        if (!this.field_70170_p.field_72995_K && (stack = player.func_184586_b(hand)).func_77973_b() instanceof PlantCardItem) {
            PlantCardItem item = (PlantCardItem)stack.func_77973_b();
            if (!this.getPlantEnumName().isBigPlant && item.plantType == Plants.PUMPKIN) {
                if (this.outerPlant.isPresent() && this.outerPlant.get() == Plants.PUMPKIN) {
                    if (this.getPumpkinLife() < 400.0f) {
                        PlantCardItem.checkSunAndHealPlant(player, this, item, stack);
                    }
                } else {
                    PlantCardItem.checkSunAndOuterPlant(player, this, item, stack);
                }
            } else if (!this.getPlantEnumName().isBigPlant && item instanceof ImitaterCardItem && ((ImitaterCardItem)item).isPlantTypeEqual(stack, Plants.PUMPKIN)) {
                if (this.outerPlant.isPresent() && this.outerPlant.get() == Plants.PUMPKIN) {
                    if (this.getPumpkinLife() < 400.0f) {
                        PlantCardItem.checkSunAndHealPlant(player, this, item, stack);
                    }
                } else {
                    PlantCardItem.checkSunAndOuterPlant(player, this, item, stack);
                }
            } else if (item.plantType == Plants.COFFEE_BEAN) {
                PlantCardItem.checkSunAndSummonPlant(player, stack, item, this.func_180425_c(), plantEntity -> plantEntity.func_184220_m((Entity)this));
            } else if (item instanceof ImitaterCardItem && ((ImitaterCardItem)item).isPlantTypeEqual(stack, Plants.COFFEE_BEAN)) {
                ImitaterCardItem.checkSunAndSummonImitater(player, stack, item, this.func_180425_c(), imitater -> imitater.func_184220_m((Entity)this));
            } else if (this.getUpgradePlantType() == item.plantType) {
                PlantCardItem.checkSunAndSummonPlant(player, stack, item, this.func_180425_c(), plantEntity -> this.onPlantUpgrade((PVZPlantEntity)plantEntity));
            } else if (item instanceof ImitaterCardItem && ((ImitaterCardItem)item).isPlantTypeEqual(stack, this.getUpgradePlantType())) {
                ImitaterCardItem.checkSunAndSummonImitater(player, stack, item, this.func_180425_c(), imitater -> {
                    imitater.targetPlantEntity = Optional.of(this);
                });
            }
        }
        return true;
    }

    protected void onPlantUpgrade(PVZPlantEntity plantEntity) {
        if (!plantEntity.getPlantEnumName().isBigPlant) {
            plantEntity.setPumpkinLife(this.getPumpkinLife());
            this.getOuterPlantType().ifPresent(plantType -> plantEntity.setOuterPlantType((Plants)((Object)plantType)));
            plantEntity.outerSunCost = this.outerSunCost;
        }
        plantEntity.plantSunCost += this.plantSunCost;
        plantEntity.setSleepTime(this.getSleepTime());
        this.func_70106_y();
    }

    public float getCurrentHealth() {
        return this.func_110143_aJ() + this.getPumpkinLife();
    }

    public float getCurrentMaxHealth() {
        return this.func_110138_aP() + this.getPumpkinLife();
    }

    protected boolean isPlantInStage(int stage) {
        int lvl = this.getPlantLvl();
        if (stage == 1) {
            return lvl <= 6;
        }
        if (stage == 2) {
            return 7 <= lvl && lvl <= 13;
        }
        if (stage == 3) {
            return 14 <= lvl && lvl <= 20;
        }
        return false;
    }

    public int getBoostTime() {
        return (Integer)this.field_70180_af.func_187225_a(BOOST_TIME);
    }

    public void setBoostTime(int time) {
        this.field_70180_af.func_187227_b(BOOST_TIME, (Object)time);
    }

    public boolean isCharmed() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CHARMED);
    }

    public void setCharmed(boolean is) {
        this.field_70180_af.func_187227_b(IS_CHARMED, (Object)is);
    }

    public int getGoldTime() {
        return (Integer)this.field_70180_af.func_187225_a(GOLD_TIME);
    }

    public void setGoldTime(int cd) {
        this.field_70180_af.func_187227_b(GOLD_TIME, (Object)cd);
    }

    public int getAttackTime() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TIME);
    }

    public void setAttackTime(int cd) {
        this.field_70180_af.func_187227_b(ATTACK_TIME, (Object)cd);
    }

    public int getSleepTime() {
        return (Integer)this.field_70180_af.func_187225_a(SLEEP_TIME);
    }

    public void setSleepTime(int cd) {
        this.field_70180_af.func_187227_b(SLEEP_TIME, (Object)cd);
    }

    public void setPlantLvl(int lvl) {
        this.field_70180_af.func_187227_b(PLANT_LVL, (Object)lvl);
    }

    public int getPlantLvl() {
        return (Integer)this.field_70180_af.func_187225_a(PLANT_LVL);
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.field_70180_af.func_187225_a(OWNER_UUID);
    }

    public void setOwnerUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setSuperTime(int time) {
        this.field_70180_af.func_187227_b(SUPER_TIME, (Object)time);
    }

    public int getSuperTime() {
        return (Integer)this.field_70180_af.func_187225_a(SUPER_TIME);
    }

    public int getLiveTick() {
        return (Integer)this.field_70180_af.func_187225_a(LIVE_TICK);
    }

    public void setLiveTick(int tick) {
        this.field_70180_af.func_187227_b(LIVE_TICK, (Object)tick);
    }

    public float getPumpkinLife() {
        return ((Float)this.field_70180_af.func_187225_a(PUMPKIN_LIFE)).floatValue();
    }

    public void setPumpkinLife(float life) {
        this.field_70180_af.func_187227_b(PUMPKIN_LIFE, (Object)Float.valueOf(life));
    }

    public int getPlantState() {
        return (Integer)this.field_70180_af.func_187225_a(PLANT_STATES);
    }

    public void setPlantState(int state) {
        this.field_70180_af.func_187227_b(PLANT_STATES, (Object)state);
    }

    @Override
    public boolean hasMetal() {
        return (this.getPlantState() >> 0 & 1) == 1;
    }

    @Override
    public void increaseMetal() {
        int state = this.getPlantState();
        this.setPlantState(state | 1);
    }

    @Override
    public void decreaseMetal() {
        int state = this.getPlantState();
        if (this.hasMetal()) {
            --state;
        }
        this.setPlantState(state);
    }

    @Override
    public MetalTypes getMetalType() {
        return MetalTypes.LADDER;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (damageSourceIn instanceof PVZDamageSource && ((PVZDamageSource)damageSourceIn).getPVZDamageType() == PVZDamageType.EAT) {
            return (SoundEvent)SoundRegister.PLANT_HURT.get();
        }
        return super.func_184601_bQ(damageSourceIn);
    }

    protected SoundEvent getSpawnSound() {
        return this.getPlantEnumName().isWaterPlant ? (SoundEvent)SoundRegister.PLANT_IN_WATER.get() : (SoundEvent)SoundRegister.PLANT_ON_GROUND.get();
    }
}

