/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.appease;

import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.bullet.StarEntity;
import com.hungteen.pvz.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class AngelStarFruitEntity
extends PlantShooterEntity {
    public static final float PER_ANGLE = 72.0f;
    public int lightTick = 0;

    public AngelStarFruitEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 5, this.getShootRange(), 2.0f, 0.0f));
    }

    @Override
    public void normalPlantTick() {
        if (this.field_70170_p.field_72995_K) {
            if (this.lightTick > 0) {
                --this.lightTick;
            }
            if (this.getAttackTime() > 0) {
                this.lightTick = 8;
            }
        }
        super.normalPlantTick();
        if (this.isPlantInSuperMode()) {
            float now = this.getSuperTime() * 4;
            for (int i = 0; i < 5; ++i) {
                this.shootStarByAngle(now);
                now += 72.0f;
            }
        }
    }

    @Override
    public void shootBullet() {
        int i;
        float now = this.field_70759_as;
        for (i = 0; i < 5; ++i) {
            this.shootStarByAngle(now);
            now += 72.0f;
        }
        if (this.func_70681_au().nextInt(100) < this.getExtraAttackChance()) {
            now = this.field_70759_as + 36.0f;
            for (i = 0; i < 5; ++i) {
                this.shootStarByAngle(now);
                now += 72.0f;
            }
        }
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.SNOW_SHOOT.get());
    }

    public int getExtraAttackChance() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 17 + 3 * lvl;
        }
        return 80;
    }

    @Override
    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 12) {
            int now = (lvl - 1) / 4;
            return 3.0f + 0.25f * (float)now;
        }
        if (lvl <= 20) {
            int now = (lvl - 13) / 2;
            return 3.75f + 0.25f * (float)now;
        }
        return 4.5f;
    }

    @Override
    protected boolean canAttackNow() {
        return this.getAttackTime() == 2 && !this.isPlantInSuperMode();
    }

    private void shootStarByAngle(float angle) {
        double vx = -MathHelper.func_76126_a((float)(angle *= 0.01745328f));
        double vz = MathHelper.func_76134_b((float)angle);
        StarEntity.StarTypes type = this.isPlantInSuperMode() ? StarEntity.StarTypes.BIG : StarEntity.StarTypes.NORMAL;
        StarEntity pea = new StarEntity(this.field_70170_p, (LivingEntity)this, type, StarEntity.StarStates.PINK);
        pea.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)0.2f, this.func_226281_cx_());
        double speed = 1.4;
        pea.func_213293_j(vx * speed, 0.0, vz * speed);
        this.field_70170_p.func_217376_c((Entity)pea);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.9f, (float)0.5f);
    }

    @Override
    public double getMaxShootAngle() {
        return 40.0;
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(2);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.ANGEL_STAR_FRUIT;
    }

    @Override
    public int getSuperTimeLength() {
        if (this.isPlantInStage(1)) {
            return 100;
        }
        if (this.isPlantInStage(2)) {
            return 200;
        }
        return 300;
    }
}

