/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.appease;

import com.hungteen.pvz.entity.bullet.itembullet.PeaEntity;
import com.hungteen.pvz.entity.plant.appease.PeaShooterEntity;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class SplitPeaEntity
extends PeaShooterEntity {
    public static final int MAX_ROUND_TIME = 20;
    private static final DataParameter<Integer> ROUND_TICK = EntityDataManager.func_187226_a(SplitPeaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public SplitPeaEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ROUND_TICK, (Object)0);
    }

    @Override
    protected void plantBaseTick() {
        super.plantBaseTick();
        if (!this.field_70170_p.field_72995_K && this.getRoundTick() != 0 && this.getRoundTick() != 10) {
            this.rotateFacing();
        }
    }

    @Override
    public void shootBullet() {
        PeaEntity pea;
        LivingEntity target = this.func_70638_az();
        if (target == null) {
            return;
        }
        double dx = target.func_226277_ct_() - this.func_226277_ct_();
        double dz = target.func_226281_cx_() - this.func_226281_cx_();
        double y = this.func_226278_cu_() + (double)(this.func_213305_a((Pose)this.func_213283_Z()).field_220316_b * 0.7f);
        double dis = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        this.getClass();
        double tmp = 0.1 / dis;
        double deltaX = tmp * dx * (double)(this.isFacingFront() ? 1 : -1);
        double deltaZ = tmp * dz * (double)(this.isFacingFront() ? 1 : -1);
        if (this.getAttackTime() >= (this.isFacingFront() ? 2 : 1)) {
            pea = new PeaEntity(this.field_70170_p, (LivingEntity)this, this.getShootType(), this.getShootState());
            pea.func_70107_b(this.func_226277_ct_() + deltaX, y, this.func_226281_cx_() + deltaZ);
            pea.shootPea(dx, target.func_226278_cu_() + (double)target.func_213302_cg() - y, dz, this.getBulletSpeed());
            this.field_70170_p.func_217376_c((Entity)pea);
        }
        if (this.getAttackTime() >= (this.isFacingFront() ? 1 : 2)) {
            pea = new PeaEntity(this.field_70170_p, (LivingEntity)this, this.getShootType(), this.getShootState());
            pea.func_70107_b(this.func_226277_ct_() - deltaX, y, this.func_226281_cx_() - deltaZ);
            pea.shootPeaAnti(dx, target.func_226278_cu_() + (double)target.func_213302_cg() - y, dz, this.getBulletSpeed());
            this.field_70170_p.func_217376_c((Entity)pea);
        }
        this.func_184185_a(this.getShootSound(), 1.0f, 1.0f);
        this.checkAndChangeFacing();
    }

    private void checkAndChangeFacing() {
        if (this.getAttackTime() == 1 && !this.isPlantInSuperMode()) {
            int chance;
            int n = chance = this.isFacingFront() ? this.getDoubleChance() : 100 - this.getDoubleChance();
            if (this.func_70681_au().nextInt(100) < chance) {
                this.rotateFacing();
            }
        }
    }

    private void rotateFacing() {
        this.setRoundTick((this.getRoundTick() + 1) % 20);
    }

    public int getDoubleChance() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 4;
            return 20 + 10 * now;
        }
        return 60;
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(2);
    }

    public boolean isFacingFront() {
        return this.getRoundTick() == 0;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("round_tick")) {
            this.setRoundTick(compound.func_74762_e("round_tick"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("round_tick", this.getRoundTick());
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SPLIT_PEA;
    }

    public int getRoundTick() {
        return (Integer)this.field_70180_af.func_187225_a(ROUND_TICK);
    }

    public void setRoundTick(int tick) {
        this.field_70180_af.func_187227_b(ROUND_TICK, (Object)tick);
    }
}

