/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.arma;

import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.bullet.ButterEntity;
import com.hungteen.pvz.entity.bullet.KernelEntity;
import com.hungteen.pvz.entity.bullet.PultBulletEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.plant.base.PlantPultEntity;
import com.hungteen.pvz.item.tool.card.ImitaterCardItem;
import com.hungteen.pvz.item.tool.card.PlantCardItem;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class KernelPultEntity
extends PlantPultEntity {
    private static final DataParameter<Integer> CURRENT_BULLET = EntityDataManager.func_187226_a(KernelPultEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int BUTTER_CHANCE = 10;

    public KernelPultEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CURRENT_BULLET, (Object)CornTypes.KERNEL.ordinal());
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 5, this.getPultRange(), 11.0f, 10.0f));
    }

    @Override
    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack stack;
        if (!this.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND && !EntityUtil.checkCanEntityAttack((Entity)this, (Entity)player) && (stack = player.func_184586_b(hand)).func_77973_b() instanceof PlantCardItem) {
            Optional<KernelPultEntity> pult;
            PlantCardItem item = (PlantCardItem)stack.func_77973_b();
            if (item.plantType == Plants.COB_CANNON) {
                Optional<KernelPultEntity> pult2 = this.getNearByPult(player);
                if (pult2.isPresent()) {
                    PlantCardItem.checkSunAndSummonPlant(player, stack, item, this.func_180425_c(), plantEntity -> {
                        this.onPlantUpgrade((PVZPlantEntity)plantEntity);
                        plantEntity.plantSunCost += ((KernelPultEntity)pult.get()).plantSunCost;
                        ((KernelPultEntity)pult2.get()).func_70106_y();
                    });
                }
            } else if (item instanceof ImitaterCardItem && ((ImitaterCardItem)item).isPlantTypeEqual(stack, Plants.COB_CANNON) && (pult = this.getNearByPult(player)).isPresent()) {
                ImitaterCardItem.checkSunAndSummonImitater(player, stack, item, this.func_180425_c(), imitater -> {
                    imitater.targetPlantEntity = Optional.of(this);
                    imitater.plantSunCost += ((KernelPultEntity)pult.get()).plantSunCost;
                    ((KernelPultEntity)pult.get()).func_70106_y();
                });
            }
        }
        return super.func_184645_a(player, hand);
    }

    private Optional<KernelPultEntity> getNearByPult(PlayerEntity player) {
        float range = 1.5f;
        List list = this.field_70170_p.func_175647_a(KernelPultEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), pult -> !pult.func_70028_i((Entity)this) && pult.getPlantEnumName() == Plants.KERNEL_PULT && !EntityUtil.checkCanEntityAttack((Entity)pult, (Entity)player));
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(list.get(0));
    }

    @Override
    public void startPultAttack() {
        super.startPultAttack();
        this.changeBullet();
    }

    protected void changeBullet() {
        if (this.isPlantInSuperMode() && !this.isSuperOut) {
            this.setCurrentBullet(CornTypes.BUTTER);
            return;
        }
        this.setCurrentBullet(this.func_70681_au().nextInt(10) == 0 ? CornTypes.BUTTER : CornTypes.KERNEL);
    }

    @Override
    public void pultBullet() {
        LivingEntity target = this.func_70638_az();
        this.pultKernel(target, false);
    }

    @Override
    protected void doSuperAttackToTarget(LivingEntity target) {
        this.pultKernel(target, true);
    }

    protected Optional<PultBulletEntity> pultKernel(LivingEntity target, boolean isSuper) {
        if (target == null) {
            return Optional.empty();
        }
        PultBulletEntity bullet = null;
        if (isSuper || this.getCurrentBullet() == CornTypes.BUTTER) {
            bullet = new ButterEntity(this.field_70170_p, (LivingEntity)this);
        } else if (this.getCurrentBullet() == CornTypes.KERNEL) {
            bullet = new KernelEntity(this.field_70170_p, (LivingEntity)this);
        }
        if (bullet == null) {
            System.out.println("ERROR : Wrong kernel Pult Throw Bullet Type !");
            return Optional.empty();
        }
        bullet.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)1.7f, this.func_226281_cx_());
        bullet.shootPultBullet(target);
        this.field_70170_p.func_217376_c((Entity)bullet);
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.PLANT_THROW.get());
        this.setCurrentBullet(CornTypes.KERNEL);
        return Optional.of(bullet);
    }

    public EffectInstance getButterEffect() {
        return new EffectInstance((Effect)EffectRegister.BUTTER_EFFECT.get(), this.getButterDuration(), 1, false, false);
    }

    public int getButterDuration() {
        return 100;
    }

    public float getKernelDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 18) {
            int now = (lvl - 1) / 2;
            return 2.0f + 0.25f * (float)now;
        }
        if (lvl <= 19) {
            return 4.25f;
        }
        return 4.5f;
    }

    public float getButterDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 3.75f + 0.25f * (float)lvl;
        }
        return 9.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.0f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("current_bullet_type")) {
            this.setCurrentBullet(CornTypes.values()[compound.func_74762_e("current_bullet_type")]);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("current_bullet_type", this.getCurrentBullet().ordinal());
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.KERNEL_PULT;
    }

    public void setCurrentBullet(CornTypes type) {
        this.field_70180_af.func_187227_b(CURRENT_BULLET, (Object)type.ordinal());
    }

    public CornTypes getCurrentBullet() {
        return CornTypes.values()[(Integer)this.field_70180_af.func_187225_a(CURRENT_BULLET)];
    }

    public static enum CornTypes {
        KERNEL,
        BUTTER,
        ROCKET;

    }
}

