/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.assist;

import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.zombie.grassnight.TombStoneEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class GraveBusterEntity
extends PVZPlantEntity {
    private static final DataParameter<Boolean> IS_EATING = EntityDataManager.func_187226_a(GraveBusterEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final int MAX_LIVE_TICK = 100;
    private int killCount = 0;

    public GraveBusterEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.canBeCharmed = false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_EATING, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TombStoneEntity.class, 5, true, true, tomb -> tomb.func_184188_bt().isEmpty()));
        this.field_70715_bh.func_75776_a(0, (Goal)new EatTombStoneGoal(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(5.0);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (this.isEating()) {
            this.setLiveTick(0);
            if (this.getAttackTime() % 20 == 0) {
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.PLANT_HURT.get());
            }
        }
    }

    public int getAttackCD() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 102 - 2 * lvl;
        }
        return 60;
    }

    public int getMaxKillCnt() {
        if (this.isPlantInStage(1)) {
            return 1;
        }
        if (this.isPlantInStage(2)) {
            return 2;
        }
        return 3;
    }

    @Override
    public int getMaxLiveTick() {
        return 100;
    }

    @Override
    protected boolean canPlantTarget(LivingEntity entity) {
        return entity instanceof TombStoneEntity && entity.func_70089_S() && entity.func_184188_bt().isEmpty();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)1.0f, (float)1.6f);
    }

    public void setEating(boolean is) {
        this.field_70180_af.func_187227_b(IS_EATING, (Object)is);
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_EATING);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("kill_cnt", this.killCount);
        compound.func_74757_a("is_eating", this.isEating());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("kill_cnt")) {
            this.killCount = compound.func_74762_e("kill_cnt");
        }
        if (compound.func_74764_b("is_eating")) {
            this.setEating(compound.func_74767_n("is_eating"));
        }
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.GRAVE_BUSTER;
    }

    @Override
    public int getSuperTimeLength() {
        return 0;
    }

    static class EatTombStoneGoal
    extends Goal {
        private GraveBusterEntity buster;
        private LivingEntity target;

        public EatTombStoneGoal(GraveBusterEntity buster) {
            this.buster = buster;
        }

        public boolean func_75250_a() {
            LivingEntity target = this.buster.func_70638_az();
            if (target == null || !target.func_70089_S()) {
                return false;
            }
            if (!target.func_184188_bt().isEmpty()) {
                this.buster.func_70624_b(null);
                this.target = null;
                return false;
            }
            this.target = target;
            return true;
        }

        public void func_75249_e() {
            this.buster.setEating(true);
            this.buster.func_184205_a((Entity)this.target, true);
        }

        public void func_75251_c() {
            this.buster.setEating(false);
            this.target = null;
        }

        public boolean func_75253_b() {
            return this.target != null && this.target instanceof TombStoneEntity;
        }

        public void func_75246_d() {
            if (!this.buster.canPlantNormalUpdate()) {
                return;
            }
            this.buster.setAttackTime(this.buster.getAttackTime() + 1);
            if (this.buster.getAttackTime() >= this.buster.getAttackCD()) {
                this.buster.setAttackTime(0);
                this.buster.killCount++;
                this.buster.setEating(false);
                this.target.func_70097_a((DamageSource)PVZDamageSource.causeEatDamage((Entity)this.buster, (Entity)this.buster), this.target.func_110138_aP() * 1.5f);
                if (this.buster.killCount >= this.buster.getMaxKillCnt()) {
                    this.buster.func_70106_y();
                }
            }
        }
    }
}

