/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.base;

import com.hungteen.pvz.entity.ai.attack.ShooterAttackGoal;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.utils.interfaces.IShooter;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.world.World;

public abstract class PlantShooterEntity
extends PVZPlantEntity
implements IShooter {
    public PlantShooterEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)this.getShootRange());
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new ShooterAttackGoal(this));
    }

    @Override
    public void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.canAttackNow()) {
            this.shootBullet();
        }
        if (this.getAttackTime() > 0) {
            this.setAttackTime(this.getAttackTime() - 1);
        }
    }

    protected boolean canAttackNow() {
        return this.getAttackTime() > 0;
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 18) {
            int now = (lvl - 1) / 2;
            return 2.0f + 0.25f * (float)now;
        }
        if (lvl <= 19) {
            return 4.25f;
        }
        return 4.5f;
    }

    @Override
    protected boolean canPlantTarget(LivingEntity entity) {
        return this.checkY((Entity)entity) && super.canPlantTarget(entity);
    }

    @Override
    public boolean checkY(Entity target) {
        double dx = target.func_226277_ct_() - this.func_226277_ct_();
        double ly = target.func_226278_cu_() - this.func_226278_cu_() - (double)this.func_70047_e();
        double ry = ly + (double)target.func_213302_cg();
        double dz = target.func_226281_cx_() - this.func_226281_cx_();
        double dis = Math.sqrt(dx * dx + dz * dz);
        double y = dis / this.getMaxShootAngle();
        return ly <= y && ry >= -y;
    }

    public double getMaxShootAngle() {
        return 20.0;
    }

    @Override
    public float getShootRange() {
        return 40.0f;
    }

    @Override
    public int getShootCD() {
        if (this.isPlantInSuperMode()) {
            return 1;
        }
        return this.getNormalAttackCD();
    }

    @Override
    public boolean canShoot() {
        return this.canPlantNormalUpdate();
    }

    public int getNormalAttackCD() {
        return 30;
    }

    @Override
    public float getBulletSpeed() {
        return 1.0f;
    }
}

