/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.defence;

import com.hungteen.pvz.entity.plant.base.PlantDefenderEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.misc.damage.PVZDamageType;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.AlgorithmUtil;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class GarlicEntity
extends PlantDefenderEntity {
    protected final AlgorithmUtil.EntitySorter sorter;
    private GarlicEntity garlic;

    public GarlicEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.canBeCharmed = false;
        this.sorter = new AlgorithmUtil.EntitySorter((Entity)this);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof PVZDamageSource && ((PVZDamageSource)source).getPVZDamageType() == PVZDamageType.EAT && source.func_76346_g() instanceof MobEntity) {
            this.updateGarlic();
            if (this.garlic != null) {
                EntityUtil.playSound((Entity)((MobEntity)source.func_76346_g()), (SoundEvent)SoundRegister.YUCK.get());
                ((MobEntity)source.func_76346_g()).func_70624_b((LivingEntity)this.garlic);
            }
        }
        return super.func_70097_a(source, amount);
    }

    private void updateGarlic() {
        if (!EntityUtil.isEntityValid((Entity)this.garlic) || !this.func_70635_at().func_75522_a((Entity)this.garlic)) {
            this.garlic = null;
            float range = this.getChangeRange();
            List list = this.field_70170_p.func_175647_a(GarlicEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), target -> !target.func_70028_i((Entity)this) && EntityUtil.isEntityValid((Entity)target) && this.func_70635_at().func_75522_a((Entity)target));
            if (list.isEmpty()) {
                return;
            }
            Collections.sort(list, this.sorter);
            this.garlic = (GarlicEntity)list.get(0);
        }
    }

    public float getChangeRange() {
        if (this.isPlantInStage(1)) {
            return 10.0f;
        }
        if (this.isPlantInStage(2)) {
            return 15.0f;
        }
        return 20.0f;
    }

    @Override
    public float getPlantHealth() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            return 95 + 5 * lvl;
        }
        return 200.0f;
    }

    @Override
    public float getSuperLife() {
        return 0.0f;
    }

    @Override
    public float getAttractRange() {
        return 2.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.2f);
    }

    @Override
    public int getSuperTimeLength() {
        return 0;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.GARLIC;
    }
}

