/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.defence;

import com.hungteen.pvz.entity.bullet.itembullet.NutEntity;
import com.hungteen.pvz.entity.plant.defence.WallNutEntity;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GiantWallNutEntity
extends WallNutEntity {
    public GiantWallNutEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setDefenceLife(this.getSuperLife());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.getNutCount(); ++i) {
                NutEntity nut = new NutEntity(this.field_70170_p, (LivingEntity)this);
                nut.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_());
                nut.shoot((double)(this.func_70681_au().nextFloat() - 0.5f) * 1.5, 0.5, (double)(this.func_70681_au().nextFloat() - 0.5f) * 1.5);
                this.field_70170_p.func_217376_c((Entity)nut);
            }
        }
    }

    @Override
    public float getAttractRange() {
        return 7.0f;
    }

    @Override
    public float getPlantHealth() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 790 + 10 * lvl;
        }
        return 1000.0f;
    }

    @Override
    public float getSuperLife() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 970 + 30 * lvl;
        }
        return 1600.0f;
    }

    public int getNutCount() {
        if (this.isPlantInStage(1)) {
            return 50;
        }
        if (this.isPlantInStage(2)) {
            return 75;
        }
        return 100;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)2.0f, (float)3.0f);
    }

    @Override
    public Plants getUpgradePlantType() {
        return null;
    }

    @Override
    public int getSuperTimeLength() {
        return 50;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.GIANT_WALL_NUT;
    }
}

