/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.enforce;

import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.misc.SmallChomperEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ChomperEntity
extends PVZPlantEntity {
    public final int ATTACK_CD = 30;
    private final int SUPER_RANGE = 20;
    private static final DataParameter<Integer> REST_TICK = EntityDataManager.func_187226_a(ChomperEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public ChomperEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(REST_TICK, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 5.0f, 2.0f));
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.9f, 1.9f, false);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            this.field_70749_g.func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAttackTime() < this.ATTACK_CD / 2) {
                if (this.getRestTick() > 0) {
                    this.setAttackTime(0);
                    this.setRestTick(this.getRestTick() - 1);
                    return;
                }
                if (this.func_70638_az() == null) {
                    this.setAttackTime(0);
                    return;
                }
                if (!this.func_70638_az().func_70089_S() || this.func_70068_e((Entity)this.func_70638_az()) > 9.0) {
                    this.func_70624_b(null);
                    this.setAttackTime(0);
                    return;
                }
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.getAttackTime() == this.ATTACK_CD / 2) {
                    this.performAttack();
                }
            } else {
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.getAttackTime() > this.ATTACK_CD) {
                    this.setAttackTime(0);
                }
            }
        }
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        int cnt = this.getSuperAttackCnt();
        for (Entity entity : EntityUtil.getEntityTargetableEntity((Entity)this, EntityUtil.getEntityAABB((Entity)this, this.SUPER_RANGE, this.SUPER_RANGE))) {
            SmallChomperEntity chomper = (SmallChomperEntity)((EntityType)EntityRegister.SMALL_CHOMPER.get()).func_200721_a(this.field_70170_p);
            chomper.setOwner((LivingEntity)this);
            EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, chomper, entity.func_180425_c());
            if (--cnt != 0) continue;
            break;
        }
    }

    public boolean func_190530_aW() {
        return this.getAttackTime() > 0;
    }

    private void performAttack() {
        LivingEntity target = this.func_70638_az();
        if (EntityUtil.getCurrentHealth(target) <= this.getAttackDamage()) {
            this.setRestTick(this.getRestCD());
        }
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.CHOMP.get());
        target.func_70097_a((DamageSource)PVZDamageSource.causeEatDamage((Entity)this, (Entity)this), this.getAttackDamage(target));
    }

    public float getAttackDamage(LivingEntity target) {
        if (target.func_110143_aJ() <= this.getAttackDamage()) {
            return this.getAttackDamage();
        }
        return this.getAttackDamage() / 30.0f;
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 147 + 3 * lvl;
        }
        return 210.0f;
    }

    public int getRestCD() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 850 - 10 * lvl;
        }
        return 640;
    }

    public int getSuperAttackCnt() {
        if (this.isPlantInStage(1)) {
            return 3;
        }
        if (this.isPlantInStage(2)) {
            return 4;
        }
        return 5;
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("rest_tick", this.getRestTick());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("rest_tick")) {
            this.setRestTick(compound.func_74762_e("rest_tick"));
        }
    }

    public int getRestTick() {
        return (Integer)this.field_70180_af.func_187225_a(REST_TICK);
    }

    public void setRestTick(int tick) {
        this.field_70180_af.func_187227_b(REST_TICK, (Object)tick);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.CHOMPER;
    }
}

