/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.explosion;

import com.hungteen.pvz.entity.ai.target.PVZRandomTargetGoal;
import com.hungteen.pvz.entity.bullet.CornEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CobCannonEntity
extends PVZPlantEntity {
    protected static final DataParameter<Integer> CORN_NUM = EntityDataManager.func_187226_a(CobCannonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected Optional<LivingEntity> lockTarget = Optional.empty();
    protected Optional<BlockPos> lockPos = Optional.empty();
    protected int cornCnt = 0;
    protected final int MaxCornCnt = 16;
    protected int preTick = 0;

    public CobCannonEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.canCollideWithPlant = false;
        this.isImmuneToWeak = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CORN_NUM, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(2, (Goal)new PVZRandomTargetGoal((MobEntity)this, true, 10, 48.0f, 16.0f));
    }

    @Override
    public void onSpawnedByPlayer(PlayerEntity player, int lvl) {
        super.onSpawnedByPlayer(player, lvl);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getMoveSpeed());
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            ++this.preTick;
            if (this.getAttackTime() == 0 && this.preTick >= this.getPreCD()) {
                this.preTick = 0;
                this.setCornNum(Math.min(2, this.getCornNum() + 1));
            }
            if (this.getCornNum() >= 2 && !this.isPlayerRiding() && this.func_70638_az() != null) {
                this.setAttackTime(this.getAnimCD());
                this.setCornNum(this.getCornNum() - 1);
            }
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
                this.func_184188_bt().forEach(entity -> entity.func_184210_p());
                if (this.getAttackTime() == this.getAnimCD() / 2) {
                    this.startAttack();
                }
            }
        }
    }

    public void checkAndAttack() {
        if (this.getAttackTime() > 0) {
            return;
        }
        if (this.isPlayerRiding()) {
            EntityRayTraceResult entityRay;
            PlayerEntity player = (PlayerEntity)this.func_184188_bt().get(0);
            Vec3d look = player.func_70040_Z();
            Vec3d start = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
            double range = 60.0;
            Vec3d end = start.func_178787_e(look.func_72432_b().func_216372_d(range, range, range));
            RayTraceContext ray = new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player);
            BlockRayTraceResult result = this.field_70170_p.func_217299_a(ray);
            if (result.func_216346_c() != RayTraceResult.Type.MISS) {
                end = result.func_216347_e();
            }
            if ((entityRay = this.rayTraceEntities(this.field_70170_p, player, range, start, end)) != null && entityRay.func_216346_c() == RayTraceResult.Type.ENTITY) {
                if (entityRay.func_216348_a() instanceof LivingEntity) {
                    this.setAttackTime(this.getAnimCD());
                    this.setCornNum(this.getCornNum() - 1);
                    this.lockTarget = Optional.ofNullable((LivingEntity)entityRay.func_216348_a());
                }
            } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                this.setAttackTime(this.getAnimCD());
                BlockPos pos = new BlockPos(end.func_82615_a(), end.func_82617_b(), end.func_82616_c());
                this.setCornNum(this.getCornNum() - 1);
                this.lockPos = Optional.ofNullable(pos);
            }
        }
    }

    private void startAttack() {
        if (this.lockTarget.isPresent()) {
            this.shootCorn(this.lockTarget.get());
            this.lockTarget = Optional.empty();
            return;
        }
        if (this.lockPos.isPresent()) {
            this.shootCorn(this.lockPos.get());
            this.lockPos = Optional.empty();
            return;
        }
        float range = 45.0f;
        List<LivingEntity> list = EntityUtil.getViewableTargetableEntity((Entity)this, EntityUtil.getEntityAABB((Entity)this, range, range));
        int num = this.isPlantInSuperMode() ? this.getSuperCornNum() : 1;
        for (int i = 0; i < num; ++i) {
            CobCannonEntity res = this;
            if (!list.isEmpty()) {
                int pos = this.func_70681_au().nextInt(list.size());
                res = list.get(pos);
            }
            this.shootCorn((LivingEntity)res);
        }
    }

    private void shootCorn(LivingEntity target) {
        CornEntity corn = new CornEntity(this.field_70170_p, (LivingEntity)this);
        corn.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.5, this.func_226281_cx_());
        corn.shootPultBullet(target);
        corn.cornCnt = this.cornCnt;
        this.cornCnt = 0;
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.COB_LAUNCH.get());
        this.field_70170_p.func_217376_c((Entity)corn);
    }

    private void shootCorn(BlockPos pos) {
        CornEntity corn = new CornEntity(this.field_70170_p, (LivingEntity)this);
        corn.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.5, this.func_226281_cx_());
        corn.shootPultBullet(pos);
        corn.cornCnt = this.cornCnt;
        this.cornCnt = 0;
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.COB_LAUNCH.get());
        this.field_70170_p.func_217376_c((Entity)corn);
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.setAttackTime(this.getAnimCD());
    }

    @Override
    protected boolean shouldLockXZ() {
        return !this.isPlayerRiding();
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(World world, PlayerEntity player, double range, Vec3d startVec, Vec3d endVec) {
        return ProjectileHelper.func_221271_a((World)world, (Entity)player, (Vec3d)startVec, (Vec3d)endVec, (AxisAlignedBB)player.func_174813_aQ().func_186662_g(range), entity -> EntityUtil.isEntityValid(entity) && entity instanceof LivingEntity && !entity.func_70028_i((Entity)this));
    }

    public boolean isPlayerRiding() {
        for (Entity entity : this.func_184188_bt()) {
            if (!(entity instanceof PlayerEntity)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isRidingPlayer(PlayerEntity player) {
        return player.func_184187_bx() != null && player.func_184187_bx() == this;
    }

    public void func_213352_e(Vec3d p_213352_1_) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.isPlayerRiding()) {
                PlayerEntity player = (PlayerEntity)this.func_184188_bt().get(0);
                if (player == null) {
                    System.out.println("ERROR : Wrong judge !");
                    return;
                }
                this.field_70126_B = this.field_70177_z = player.field_70177_z;
                this.field_70125_A = player.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = player.field_70702_br * 0.5f;
                float f1 = player.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.field_70123_F) {
                    Vec3d vec3d = this.func_213322_ci();
                    this.func_213293_j(vec3d.field_72450_a, 0.2, vec3d.field_72449_c);
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_213352_e(new Vec3d((double)f, p_213352_1_.field_72448_b, (double)f1));
                this.field_184618_aE = this.field_70721_aZ;
                double d2 = this.func_226277_ct_() - this.field_70169_q;
                double d3 = this.func_226281_cx_() - this.field_70166_s;
                float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d3 * d3)) * 4.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(p_213352_1_);
            }
        }
    }

    @Override
    protected boolean checkNormalPlantWeak() {
        if (this.func_70090_H()) {
            return true;
        }
        return super.checkNormalPlantWeak();
    }

    protected boolean mountTo(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70177_z = player.field_70177_z;
            this.field_70125_A = player.field_70125_A;
            player.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    @Override
    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (player.func_226563_dT_() || EntityUtil.checkCanEntityAttack((Entity)this, (Entity)player)) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (this.getAttackTime() == 0 && stack.func_190926_b()) {
            return this.mountTo(player);
        }
        if (stack.func_77973_b() == ItemRegister.CORN.get()) {
            if (this.cornCnt < this.MaxCornCnt) {
                ++this.cornCnt;
                stack.func_190918_g(Math.min(stack.func_190916_E(), this.MaxCornCnt - this.cornCnt));
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public double func_70042_X() {
        return 0.8;
    }

    protected boolean func_184219_q(Entity passenger) {
        return !EntityUtil.checkCanEntityAttack((Entity)this, passenger) && super.func_184219_q(passenger);
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return false;
    }

    public boolean func_205710_ba() {
        return false;
    }

    public int getPreCD() {
        return 1000;
    }

    public int getSuperCornNum() {
        if (this.isPlantInStage(1)) {
            return 4;
        }
        if (this.isPlantInStage(2)) {
            return 5;
        }
        return 6;
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 145 + 5 * lvl;
        }
        return 250.0f;
    }

    public float getMoveSpeed() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 0.19f + 0.1f * (float)lvl;
        }
        return 0.4f;
    }

    public int getAnimCD() {
        return 60;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)1.25f, (float)1.0f);
    }

    @Override
    public int getSuperTimeLength() {
        return 60;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        Entity entity;
        super.func_70037_a(compound);
        if (compound.func_74764_b("cannon_pre_tick")) {
            this.preTick = compound.func_74762_e("cannon_pre_tick");
        }
        if (compound.func_74764_b("cannon_corn_num")) {
            this.setCornNum(compound.func_74762_e("cannon_corn_num"));
        }
        if (compound.func_74764_b("cannon_pop_corn_cnt")) {
            this.cornCnt = compound.func_74762_e("cannon_pop_corn_cnt");
        }
        if (compound.func_74764_b("cannon_lock_target") && (entity = this.field_70170_p.func_73045_a(compound.func_74762_e("cannon_lock_target"))) instanceof LivingEntity) {
            this.lockTarget = Optional.ofNullable((LivingEntity)entity);
        }
        if (compound.func_74764_b("cannon_lock_pos")) {
            CompoundNBT nbt = compound.func_74775_l("cannon_lock_pos");
            this.lockPos = Optional.ofNullable(new BlockPos(nbt.func_74762_e("lock_posX"), nbt.func_74762_e("lock_posY"), nbt.func_74762_e("lock_posZ")));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("cannon_pre_tick", this.preTick);
        compound.func_74768_a("cannon_corn_num", this.getCornNum());
        compound.func_74768_a("cannon_pop_corn_cnt", this.cornCnt);
        if (this.lockTarget.isPresent()) {
            compound.func_74768_a("cannon_lock_target", this.lockTarget.get().func_145782_y());
        }
        if (this.lockPos.isPresent()) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("lock_posX", this.lockPos.get().func_177958_n());
            nbt.func_74768_a("lock_posY", this.lockPos.get().func_177956_o());
            nbt.func_74768_a("lock_posZ", this.lockPos.get().func_177952_p());
            compound.func_218657_a("cannon_lock_pos", (INBT)nbt);
        }
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.COB_CANNON;
    }

    public int getCornNum() {
        return (Integer)this.field_70180_af.func_187225_a(CORN_NUM);
    }

    public void setCornNum(int num) {
        this.field_70180_af.func_187227_b(CORN_NUM, (Object)num);
    }
}

