/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.explosion;

import com.hungteen.pvz.entity.plant.defence.WallNutEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class ExplodeONutEntity
extends WallNutEntity {
    public ExplodeONutEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.explode((Entity)this);
        } else {
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.RED_BOMB.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void explode(Entity entity) {
        float len = 2.0f;
        AxisAlignedBB aabb = EntityUtil.getEntityAABB(entity, len, len);
        EntityUtil.getAttackEntities((Entity)this, aabb).forEach(target -> target.func_70097_a((DamageSource)PVZDamageSource.causeExplosionDamage((Entity)this, (Entity)this), this.getAttackDamage()));
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.CHERRY_BOMB.get());
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.explode((Entity)this);
        EntityUtil.spawnParticle((Entity)this, 0);
        if (this.getExtraAttackChance() > 0) {
            List<Entity> list = EntityUtil.getAttackEntities((Entity)this, EntityUtil.getEntityAABB((Entity)this, 40.0, 40.0));
            if (list.isEmpty()) {
                return;
            }
            for (int i = 0; i < this.getExtraAttackChance(); ++i) {
                Entity target = list.get(this.func_70681_au().nextInt(list.size()));
                this.explode(target);
                EntityUtil.spawnParticle(target, 0);
            }
        }
    }

    public int getExtraAttackChance() {
        if (this.isPlantInStage(1)) {
            return 0;
        }
        if (this.isPlantInStage(2)) {
            return 1;
        }
        return 2;
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            return 140 + 5 * lvl;
        }
        return 240.0f;
    }

    @Override
    public float getSuperLife() {
        return 0.0f;
    }

    @Override
    public Plants getUpgradePlantType() {
        return null;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.EXPLODE_O_NUT;
    }
}

