/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.flame;

import com.hungteen.pvz.entity.bullet.itembullet.PeaEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.plant.interfaces.ILightPlant;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;

public class TorchWoodEntity
extends PVZPlantEntity
implements ILightPlant {
    private static final DataParameter<Boolean> SUPER_FLAME = EntityDataManager.func_187226_a(TorchWoodEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public TorchWoodEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.canBeCharmed = false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUPER_FLAME, (Object)false);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (this.field_70170_p.field_72995_K) {
            if (this.IsSuperFlame()) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.BLUE_FLAME.get(), this.func_226277_ct_(), this.func_226278_cu_() + 1.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            } else {
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.YELLOW_FLAME.get(), this.func_226277_ct_(), this.func_226278_cu_() + 1.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 40 == 0) {
            int range = 15;
            this.giveLightToPlayers(range);
        }
        if (this.isPlantInSuperMode()) {
            this.fireballRain();
        }
    }

    private void giveLightToPlayers(float range) {
        this.field_70170_p.func_175647_a(PlayerEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), player -> !EntityUtil.checkCanEntityAttack((Entity)this, (Entity)player)).forEach(player -> player.func_195064_c(this.getLightEyeEffect()));
    }

    private void fireballRain() {
        double dx = (this.func_70681_au().nextFloat() - 0.5f) * 6.0f;
        double dz = (this.func_70681_au().nextFloat() - 0.5f) * 6.0f;
        double dy = 10.0;
        PeaEntity pea = new PeaEntity(this.field_70170_p, (LivingEntity)this, PeaEntity.Type.NORMAL, PeaEntity.State.FIRE);
        pea.func_70107_b(this.func_226277_ct_() + dx, this.func_226278_cu_() + dy, this.func_226281_cx_() + dz);
        pea.func_213293_j(0.0, -0.4, 0.0);
        this.field_70170_p.func_217376_c((Entity)pea);
    }

    @Override
    public EffectInstance getLightEyeEffect() {
        return new EffectInstance((Effect)EffectRegister.LIGHT_EYE_EFFECT.get(), 100, 0, false, false);
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.setSuperFlame(true);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.95f, 1.95f, false);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.TORCH_WOOD;
    }

    @Override
    public int getSuperTimeLength() {
        if (this.isPlantInStage(1)) {
            return 30;
        }
        if (this.isPlantInStage(2)) {
            return 50;
        }
        return 80;
    }

    public boolean IsSuperFlame() {
        return (Boolean)this.field_70180_af.func_187225_a(SUPER_FLAME);
    }

    public void setSuperFlame(boolean is) {
        this.field_70180_af.func_187227_b(SUPER_FLAME, (Object)is);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("is_super_fire")) {
            this.setSuperFlame(compound.func_74767_n("is_super_fire"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("is_super_fire", this.IsSuperFlame());
    }
}

