/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.light;

import com.hungteen.pvz.block.special.GoldTileBlock;
import com.hungteen.pvz.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.register.BlockRegister;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.world.World;

public class GoldLeafEntity
extends PlantBomberEntity {
    public static final int GOLD_GEN_CD = 400;

    public GoldLeafEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.canCollideWithPlant = false;
        this.canBeCharmed = false;
    }

    @Override
    public void startBomb() {
        Block block = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c();
        int lvl = GoldLeafEntity.getBlockGoldLevel(block);
        if (lvl == -1 || lvl >= this.getTileLevel()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175656_a(this.func_180425_c().func_177977_b(), this.getGoldTileByLvl(this.getTileLevel()).func_176223_P());
        }
    }

    public static int getBlockGoldLevel(Block block) {
        if (block instanceof GoldTileBlock) {
            return ((GoldTileBlock)block).lvl;
        }
        if (block == Blocks.field_150340_R) {
            return 0;
        }
        return -1;
    }

    public static int getGoldGenAmount(int lvl) {
        if (lvl == 1) {
            return 25;
        }
        if (lvl == 2) {
            return 50;
        }
        return 75;
    }

    private Block getGoldTileByLvl(int lvl) {
        if (lvl == 1) {
            return (Block)BlockRegister.GOLD_TILE1.get();
        }
        if (lvl == 2) {
            return (Block)BlockRegister.GOLD_TILE2.get();
        }
        if (lvl == 3) {
            return (Block)BlockRegister.GOLD_TILE3.get();
        }
        System.out.println("Warn : Wrong use for gold tile !");
        return Blocks.field_150340_R;
    }

    public int getTileLevel() {
        if (this.isPlantInStage(1)) {
            return 1;
        }
        if (this.isPlantInStage(2)) {
            return 2;
        }
        return 3;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.6f, (float)1.0f);
    }

    @Override
    public int getReadyTime() {
        return 60;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.GOLD_LEAF;
    }
}

