/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.light;

import com.hungteen.pvz.entity.plant.base.PlantProducerEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class SunShroomEntity
extends PlantProducerEntity {
    protected static final int GROW_TICK = 1800;
    private static final DataParameter<Integer> GROW_ANIM = EntityDataManager.func_187226_a(SunShroomEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public final int growAnimTo = 10;

    public SunShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GROW_ANIM, (Object)0);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (this.getGrowAnim() > 0 && this.getGrowAnim() < this.growAnimTo) {
            this.setGrowAnim(this.getGrowAnim() + 1);
        }
        if (!this.hasGrowUp() && this.getLiveTick() > 1800) {
            this.grow();
        }
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        if (!this.hasGrowUp()) {
            this.grow();
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.hasGrowUp() ? EntitySize.func_220314_b((float)0.6f, (float)0.8f) : EntitySize.func_220314_b((float)0.4f, (float)0.4f);
    }

    private void grow() {
        this.setGrowAnim(1);
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.PLANT_GROW.get());
        }
    }

    @Override
    public void genSomething() {
        this.genSun(this.getCurrentSunAmount());
    }

    @Override
    public void genSuper() {
        for (int i = 0; i < 4; ++i) {
            this.genSun(this.getSunAmount());
        }
    }

    public boolean hasGrowUp() {
        return this.getGrowAnim() > 0;
    }

    private int getCurrentSunAmount() {
        return this.hasGrowUp() ? this.getSunAmount() : 15;
    }

    public int getSunAmount() {
        if (this.isPlantInStage(1)) {
            return 25;
        }
        if (this.isPlantInStage(2)) {
            return 35;
        }
        return 50;
    }

    @Override
    public int getGenCD() {
        return 600;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("grow_anim", this.getGrowAnim());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("grow_anim")) {
            this.setGrowAnim(compound.func_74762_e("grow_anim"));
        }
    }

    public void setGrowAnim(int tick) {
        this.field_70180_af.func_187227_b(GROW_ANIM, (Object)tick);
    }

    public int getGrowAnim() {
        return (Integer)this.field_70180_af.func_187225_a(GROW_ANIM);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SUN_SHROOM;
    }
}

