/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.magic;

import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.roof.GargantuarEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.misc.damage.PVZDamageType;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class HypnoShroomEntity
extends PVZPlantEntity {
    public HypnoShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.isPlantSleeping() && cause instanceof PVZDamageSource && ((PVZDamageSource)cause).getPVZDamageType() == PVZDamageType.EAT) {
            if (this.isPlantInSuperMode()) {
                if (cause.func_76346_g() != null) {
                    cause.func_76346_g().func_70106_y();
                    GargantuarEntity gar = (GargantuarEntity)((EntityType)EntityRegister.GARGANTUAR.get()).func_200721_a(this.field_70170_p);
                    EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, (MobEntity)gar, cause.func_76346_g().func_180425_c());
                    gar.func_70606_j(gar.func_110138_aP() * this.getSummonHealth());
                    gar.onCharmed(this);
                }
            } else if (cause.func_76346_g() instanceof PVZZombieEntity) {
                PVZZombieEntity zombie = (PVZZombieEntity)cause.func_76346_g();
                zombie.onCharmed(this);
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.CHARM.get());
                float life = zombie.func_110143_aJ();
                float max = zombie.func_110138_aP();
                float std = max * this.getHealHealth();
                float need = MathHelper.func_76131_a((float)(std - life), (float)0.0f, (float)max);
                zombie.func_70691_i(need);
            }
        }
    }

    @Override
    public float getPlantHealth() {
        return 30.0f;
    }

    public float getHealHealth() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 0.12f + 0.08f * (float)lvl;
        }
        return 1.0f;
    }

    public float getSummonHealth() {
        if (this.isPlantInStage(1)) {
            return 0.5f;
        }
        if (this.isPlantInStage(2)) {
            return 0.75f;
        }
        return 1.0f;
    }

    @Override
    public boolean isPlantImmuneTo(DamageSource source) {
        return false;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.7f, (float)1.9f);
    }

    @Override
    public int getSuperTimeLength() {
        return 2400;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.HYPNO_SHROOM;
    }
}

