/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.magic;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class StrangeCatEntity
extends PVZPlantEntity {
    public static final int ANIM_CD = 10;
    private int restTick = 0;

    public StrangeCatEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.isImmuneToWeak = true;
        this.restTick = this.getRestCD();
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.STRANGE_CAT;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 4.0f, 2.0f));
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            this.field_70749_g.func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            if (!this.isSuitableTarget(this.func_70638_az())) {
                this.func_70624_b(null);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null) {
                this.setAttackTime(10);
            } else if (this.restTick <= 0) {
                if (this.getAttackTime() > 0) {
                    this.setAttackTime(this.getAttackTime() - 1);
                } else {
                    this.performAttack(this.func_70638_az());
                }
            }
            this.restTick = Math.max(0, this.restTick - 1);
        }
    }

    public void onSelfCopy(LivingEntity target) {
        StrangeCatEntity cat = (StrangeCatEntity)((EntityType)EntityRegister.STRANGE_CAT.get()).func_200721_a(this.field_70170_p);
        PlantUtil.copyPlantData(cat, this);
        if (this.func_70681_au().nextInt((Integer)PVZConfig.COMMON_CONFIG.EntitySettings.StrangeCatNameChance.get()) == 0) {
            List<String> list = Arrays.asList("\u947a\ufe41\u5ab7", "Rua\u941a\ufffd");
            int pos = this.func_70681_au().nextInt(list.size());
            cat.func_200203_b((ITextComponent)new StringTextComponent(list.get(pos)));
        }
        EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, (MobEntity)cat, target.func_180425_c());
    }

    @Override
    protected boolean canPlantTarget(LivingEntity entity) {
        return super.canPlantTarget(entity) && this.isSuitableTarget(entity);
    }

    private void performAttack(LivingEntity target) {
        target.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this).setCopyDamage(), this.getAttackDamage());
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.BRUH.get());
        this.restTick = this.getRestCD();
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.BRUH.get());
        EntityUtil.getRandomLivingInRange(this.field_70170_p, (LivingEntity)this, EntityUtil.getEntityAABB((Entity)this, 20.0, 20.0), this.getSuperAttackCount()).forEach(target -> target.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this).setCopyDamage(), this.getAttackDamage()));
    }

    public boolean isSuitableTarget(LivingEntity target) {
        return EntityUtil.getCurrentHealth(target) <= this.getAttackDamage();
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 156 + 4 * lvl;
        }
        return 240.0f;
    }

    public int getSuperAttackCount() {
        if (this.isPlantInStage(1)) {
            return 1;
        }
        if (this.isPlantInStage(2)) {
            return 2;
        }
        return 3;
    }

    public int getRestCD() {
        int lvl = this.getPlantLvl();
        if (lvl <= 19) {
            return 1210 - 10 * lvl;
        }
        return 1000;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.8f, 1.0f, false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("rest_tick", this.restTick);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("rest_tick")) {
            this.restTick = compound.func_74762_e("rest_tick");
        }
    }

    @Override
    public int getSuperTimeLength() {
        return 30;
    }
}

