/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.plant.toxic;

import com.hungteen.pvz.entity.ai.target.PVZNearestTargetGoal;
import com.hungteen.pvz.entity.bullet.itembullet.SporeEntity;
import com.hungteen.pvz.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ScaredyShroomEntity
extends PlantShooterEntity {
    protected final double LENTH = 0.2;
    private static final DataParameter<Integer> SCARE_TIME = EntityDataManager.func_187226_a(ScaredyShroomEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int ANIM_TIME = 15;

    public ScaredyShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCARE_TIME, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, 5, this.getShootRange(), 2.0f, 0.0f));
    }

    @Override
    public void normalPlantTick() {
        super.normalPlantTick();
        this.func_213323_x_();
        if (!this.field_70170_p.field_72995_K) {
            int time = MathHelper.func_76125_a((int)(this.getScareTime() - 1), (int)0, (int)15);
            if (this.func_70638_az() != null) {
                double dis = this.getScareDistance();
                if (this.func_70068_e((Entity)this.func_70638_az()) <= dis * dis) {
                    time = MathHelper.func_76125_a((int)(this.getScareTime() + 1), (int)0, (int)15);
                }
            }
            this.setScareTime(time);
        }
    }

    public float getScareDistance() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 5;
            return 5 - now;
        }
        return 2.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.6f, (float)(1.6f - (float)this.getScareTime() * 1.0f / 15.0f));
    }

    @Override
    public void shootBullet() {
        LivingEntity target = this.func_70638_az();
        if (target == null || this.isScared()) {
            return;
        }
        double dx = target.func_226277_ct_() - this.func_226277_ct_();
        double dz = target.func_226281_cx_() - this.func_226281_cx_();
        double y = this.func_226278_cu_() + (double)(this.func_213305_a((Pose)this.func_213283_Z()).field_220316_b * 0.7f);
        double dis = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double tmp = this.LENTH / dis;
        double deltaX = tmp * dx;
        double deltaZ = tmp * dz;
        SporeEntity spore = new SporeEntity(this.field_70170_p, (LivingEntity)this);
        spore.func_70107_b(this.func_226277_ct_() + deltaX, y, this.func_226281_cx_() + deltaZ);
        spore.shootPea(dx, target.func_226278_cu_() + (double)target.func_213302_cg() - y, dz, this.getBulletSpeed());
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.PUFF.get());
        this.field_70170_p.func_217376_c((Entity)spore);
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(1);
    }

    @Override
    public float getBulletSpeed() {
        return 1.2f;
    }

    @Override
    public int getSuperTimeLength() {
        if (this.isPlantInStage(1)) {
            return 100;
        }
        if (this.isPlantInStage(2)) {
            return 120;
        }
        return 140;
    }

    public int getScareTime() {
        return (Integer)this.field_70180_af.func_187225_a(SCARE_TIME);
    }

    public void setScareTime(int time) {
        this.field_70180_af.func_187227_b(SCARE_TIME, (Object)time);
    }

    public boolean isScared() {
        return this.getScareTime() > 0;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SCAREDY_SHROOM;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("scare_time", this.getScareTime());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("scare_time")) {
            this.setScareTime(compound.func_74762_e("scare_time"));
        }
    }
}

