/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.grassday;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.zombie.grassday.NormalZombieEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.enums.MetalTypes;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IHasMetal;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class BucketHeadZombieEntity
extends NormalZombieEntity
implements IHasMetal {
    public static final float BUCKET_HEALTH = 110.0f;

    public BucketHeadZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.hasDirectDefence = true;
        this.increaseMetal();
    }

    @Override
    public float getLife() {
        return 20.0f;
    }

    @Override
    public boolean hasMetal() {
        return this.getDefenceLife() > 0.0f;
    }

    @Override
    public void decreaseMetal() {
        this.setDefenceLife(0.0f);
    }

    @Override
    public void increaseMetal() {
        this.setDefenceLife(110.0f);
    }

    @Override
    public MetalTypes getMetalType() {
        return MetalTypes.BUCKET_HEAD;
    }

    @Override
    public SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.hasMetal() ? (SoundEvent)SoundRegister.METAL_HIT.get() : super.func_184601_bQ(damageSourceIn);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.BUCKETHEAD_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.BUCKETHEAD_ZOMBIE;
    }
}

