/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.grassnight;

import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.grassnight.BackupDancerEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class DancingZombieEntity
extends PVZZombieEntity {
    private static final DataParameter<Integer> SUMMON_TIME = EntityDataManager.func_187226_a(DancingZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int DANCER_NUM = 4;
    private static final float[][] POS_OFFSET = new float[][]{{2.0f, 0.0f}, {-2.0f, 0.0f}, {0.0f, 2.0f}, {0.0f, -2.0f}};
    public static final int SUMMON_CD = 10;
    public static final int DANCE_CD = 100;
    private final int minWalkCD = 60;
    private final int maxWalkCD = 300;
    private int walkCD = 0;

    public DancingZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUMMON_TIME, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getAttackTime() > 0 ? 0.0 : (double)0.19f);
        }
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getSummonTime() > 0) {
                this.setSummonTime(this.getSummonTime() - 1);
                return;
            }
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            } else if (this.getAttackTime() == 0) {
                if (this.walkCD == 0) {
                    if (this.func_70681_au().nextFloat() < 0.05f) {
                        this.setAttackTime(100);
                        int num = this.shouldSummon();
                        if (num > 0) {
                            this.setSummonTime(10);
                            this.summonDancer(num);
                        }
                        this.walkCD = this.func_70681_au().nextInt(this.maxWalkCD - this.minWalkCD + 1) + this.minWalkCD;
                    }
                } else if (this.walkCD > 0) {
                    --this.walkCD;
                }
            }
        }
    }

    private void summonDancer(int num) {
        for (int i = 0; i < 4; ++i) {
            if (this.func_70681_au().nextInt(4) >= num) continue;
            BackupDancerEntity dancer = (BackupDancerEntity)((EntityType)EntityRegister.BACKUP_DANCER.get()).func_200721_a(this.field_70170_p);
            BlockPos pos = this.func_180425_c().func_177963_a((double)POS_OFFSET[i][0], 0.0, (double)POS_OFFSET[i][1]);
            dancer.setOwnerId(this.func_145782_y());
            dancer.setCharmed(this.isCharmed());
            EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, (MobEntity)dancer, pos);
        }
    }

    private int shouldSummon() {
        List list = this.field_70170_p.func_175647_a(BackupDancerEntity.class, EntityUtil.getEntityAABB((Entity)this, 50.0, 50.0), zombie -> this.func_70685_l((Entity)zombie) && !zombie.isCharmed() && zombie.func_70089_S() && zombie.getDancerOwner() == this);
        return 4 - list.size();
    }

    @Override
    public float getLife() {
        return 50.0f;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("zombie_summon_tick")) {
            this.setSummonTime(compound.func_74762_e("zombie_summon_tick"));
        }
        if (compound.func_74764_b("zombie_walk_cd")) {
            this.walkCD = compound.func_74762_e("zombie_walk_cd");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("zombie_summon_tick", this.getSummonTime());
        compound.func_74768_a("zombie_walk_cd", this.walkCD);
    }

    public int getSummonTime() {
        return (Integer)this.field_70180_af.func_187225_a(SUMMON_TIME);
    }

    public void setSummonTime(int time) {
        this.field_70180_af.func_187227_b(SUMMON_TIME, (Object)time);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.DANCING_ZOMBIE;
    }
}

