/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.grassnight;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.plant.spear.SpikeRockEntity;
import com.hungteen.pvz.entity.zombie.grassnight.FootballZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.MetalTypes;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class GigaFootballZombieEntity
extends FootballZombieEntity {
    public static final float GIGA_HEALTH = 300.0f;
    public boolean hasChanged = false;
    private final int minRushCD = 200;
    private final int maxRushCD = 600;

    public GigaFootballZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
    }

    @Override
    public void increaseMetal() {
        this.setDefenceLife(300.0f);
    }

    @Override
    public MetalTypes getMetalType() {
        return MetalTypes.GIGA_HELMET;
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.hasChanged && this.getAttackTime() == 0) {
                this.updateRush(true);
                this.hasChanged = true;
            }
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            }
        }
    }

    @Override
    protected boolean shouldCollideWithEntity(LivingEntity target) {
        return EntityUtil.checkCanEntityAttack((Entity)this, (Entity)target);
    }

    @Override
    protected void func_85033_bc() {
        double dd = this.getCollideWidthOffset();
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(dd, 0.0, dd));
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_223592_c(GameRules.field_223616_s);
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (((Entity)list.get(k)).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                LivingEntity target = (LivingEntity)list.get(l);
                if (target == this || !this.shouldCollideWithEntity(target)) continue;
                if (this.getAttackTime() == 0) {
                    target.func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this), target.func_110138_aP());
                    this.updateRushCD();
                }
                this.func_82167_n((Entity)target);
            }
        }
    }

    protected void updateRushCD() {
        this.hasChanged = false;
        this.updateRush(false);
        this.setAttackTime(this.func_70681_au().nextInt(this.maxRushCD - this.minRushCD + 1) + this.minRushCD);
    }

    @Override
    public boolean canBeCold() {
        return this.getAttackTime() > 0;
    }

    @Override
    protected boolean canZombieTarget(LivingEntity target) {
        if (target instanceof SpikeRockEntity) {
            return true;
        }
        return super.canZombieTarget(target);
    }

    @Override
    public float getLife() {
        return 100.0f;
    }

    protected void updateRush(boolean is) {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(is ? (double)0.28f : (double)0.22f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("has_changed_speed")) {
            this.hasChanged = compound.func_74767_n("has_changed_speed");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("has_changed_speed", this.hasChanged);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.GIGA_FOOTBALL_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.GIGA_FOOTBALL_ZOMBIE;
    }
}

