/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.grassnight;

import com.hungteen.pvz.entity.drop.CoinEntity;
import com.hungteen.pvz.entity.drop.JewelEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.base.UnderGroundZombieEntity;
import com.hungteen.pvz.entity.zombie.other.NobleZombieEntity;
import com.hungteen.pvz.item.tool.card.ImitaterCardItem;
import com.hungteen.pvz.item.tool.card.PlantCardItem;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TombStoneEntity
extends UnderGroundZombieEntity {
    public static final Zombies[] GROUND_ZOMBIES = new Zombies[]{Zombies.NORMAL_ZOMBIE, Zombies.CONEHEAD_ZOMBIE, Zombies.BUCKETHEAD_ZOMBIE};
    private int currentSummonCD = this.func_70681_au().nextInt(this.maxSummonCD - this.minSummonCD + 1) + this.minSummonCD;
    private int minSummonCD = 360;
    private int maxSummonCD = 1200;

    public TombStoneEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canBeButter = false;
        this.canBeCold = false;
        this.canBeCharm = false;
        this.canBeMini = false;
        this.canBeFrozen = false;
        this.canBeStealByBungee = false;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, NobleZombieEntity.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.getAttackTime() >= 0 && this.canSummonZombie()) {
            this.setAttackTime(this.getAttackTime() + 1);
            if (this.getAttackTime() >= this.currentSummonCD) {
                this.summonZombie();
                this.setAttackTime(0);
                this.currentSummonCD = this.func_70681_au().nextInt(this.maxSummonCD - this.minSummonCD + 1) + this.minSummonCD;
            }
        }
    }

    @Override
    protected boolean shouldCollideWithEntity(LivingEntity target) {
        return target instanceof TombStoneEntity;
    }

    public void summonZombie() {
        int pos = this.func_70681_au().nextInt(GROUND_ZOMBIES.length);
        PVZZombieEntity zombie = ZombieUtil.getZombieEntity(this.field_70170_p, GROUND_ZOMBIES[pos]);
        if (zombie != null) {
            if (zombie instanceof UnderGroundZombieEntity) {
                ((UnderGroundZombieEntity)zombie).setRiseType(true);
            }
            EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, (MobEntity)zombie, this.func_180425_c());
        }
    }

    protected boolean canSummonZombie() {
        return this.func_70638_az() != null;
    }

    public static boolean canTombSpawn(EntityType<? extends PVZZombieEntity> zombieType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        return worldIn instanceof ServerWorld && !((ServerWorld)worldIn).func_72935_r() ? TombStoneEntity.canZombieSpawn(zombieType, worldIn, reason, pos, rand) : false;
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            if (this.func_184188_bt().isEmpty() && stack.func_77973_b() instanceof PlantCardItem) {
                PlantCardItem cardItem = (PlantCardItem)stack.func_77973_b();
                if (cardItem.plantType == Plants.GRAVE_BUSTER) {
                    PlantCardItem.checkSunAndSummonPlant(player, stack, cardItem, this.func_180425_c(), plantEntity -> plantEntity.func_70624_b((LivingEntity)this));
                } else if (cardItem instanceof ImitaterCardItem && ((ImitaterCardItem)cardItem).isPlantTypeEqual(stack, Plants.GRAVE_BUSTER)) {
                    ImitaterCardItem.checkSunAndSummonImitater(player, stack, cardItem, this.func_180425_c(), imitater -> imitater.func_70624_b((LivingEntity)this));
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected void dropCoinOrSpecial() {
        int num = this.func_70681_au().nextInt(1000);
        if (num == 0) {
            JewelEntity jewel = (JewelEntity)((EntityType)EntityRegister.JEWEL.get()).func_200721_a(this.field_70170_p);
            EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, jewel, this.func_180425_c());
            return;
        }
        if (num == 1) {
            ItemEntity chocolate = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), new ItemStack((IItemProvider)ItemRegister.CHOCOLATE.get()));
            EntityUtil.playSound((Entity)chocolate, (SoundEvent)SoundRegister.JEWEL_DROP.get());
            this.field_70170_p.func_217376_c((Entity)chocolate);
            return;
        }
        if (num < 1000) {
            int amount = CoinEntity.CoinType.COPPER.money;
            if (num < 12) {
                amount = CoinEntity.CoinType.GOLD.money;
            } else if (num < 112) {
                amount = CoinEntity.CoinType.SILVER.money;
            }
            CoinEntity coin = (CoinEntity)((EntityType)EntityRegister.COIN.get()).func_200721_a(this.field_70170_p);
            coin.setAmount(amount);
            EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, coin, this.func_180425_c());
            return;
        }
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.6f);
    }

    @Override
    public float getLife() {
        return 70.0f;
    }

    public double func_70042_X() {
        return 0.0;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return null;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.TOMB_STONE;
    }
}

