/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.other;

import com.hungteen.pvz.entity.misc.ZombieHandEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.base.UnderGroundZombieEntity;
import com.hungteen.pvz.entity.zombie.other.MournerZombieEntity;
import com.hungteen.pvz.entity.zombie.other.NobleZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.event.ForgeEventFactory;

public class CoffinEntity
extends UnderGroundZombieEntity {
    private static final DataParameter<Integer> GUARD_STATE = EntityDataManager.func_187226_a(CoffinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.WHITE, BossInfo.Overlay.NOTCHED_6).func_186741_a(true);

    public CoffinEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.particleNum = 3;
        this.canBeButter = false;
        this.canBeCold = false;
        this.canBeCharm = false;
        this.canBeMini = false;
        this.canBeFrozen = false;
        this.canBeStealByBungee = false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GUARD_STATE, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.18f);
    }

    @Override
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DIRT_RISE.get());
            for (Entity target : EntityUtil.getEntityAttackableTarget((Entity)this, EntityUtil.getEntityAABB((Entity)this, 50.0, 50.0))) {
                ZombieHandEntity hand = (ZombieHandEntity)((EntityType)EntityRegister.ZOMBIE_HAND.get()).func_200721_a(this.field_70170_p);
                hand.setOwner((LivingEntity)this);
                EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, hand, target.func_180425_c());
            }
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        float percent = this.func_110143_aJ() / this.func_110138_aP();
        this.bossInfo.func_186735_a(percent);
        if (this.func_70089_S()) {
            for (int i = 0; i < 4; ++i) {
                if (this.isGuardGone(i) || !(percent < (float)(5 - i) * 1.0f / 6.0f)) continue;
                this.setGuardStateById(i, 1);
                MournerZombieEntity zombie = (MournerZombieEntity)((EntityType)EntityRegister.MOURNER_ZOMBIE.get()).func_200721_a(this.field_70170_p);
                zombie.setRightShake((i & 1) == 0);
                EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, (MobEntity)zombie, this.func_70638_az() == null ? this.func_180425_c() : this.func_70638_az().func_180425_c());
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70123_F && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            boolean flag = false;
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(0.2);
            for (BlockPos blockpos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)axisalignedbb.field_72340_a), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72338_b), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72339_c), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72336_d), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72337_e), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72334_f))) {
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (!(block instanceof LeavesBlock)) continue;
                flag = this.field_70170_p.func_225521_a_(blockpos, true, (Entity)this) || flag;
            }
            if (!flag && this.field_70122_E) {
                this.func_70664_aZ();
            }
        }
    }

    @Override
    protected void func_70609_aI() {
        this.func_70106_y();
        NobleZombieEntity boss = (NobleZombieEntity)((EntityType)EntityRegister.NOBLE_ZOMBIE.get()).func_200721_a(this.field_70170_p);
        EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, (MobEntity)boss, this.func_180425_c());
    }

    @Override
    protected boolean shouldCollideWithEntity(LivingEntity target) {
        return EntityUtil.checkCanEntityAttack((Entity)this, (Entity)target);
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        if (entityIn instanceof PVZPlantEntity) {
            PVZPlantEntity plant = (PVZPlantEntity)entityIn;
            plant.func_70097_a(PVZDamageSource.causeCrushDamage((Entity)this, (Entity)this), plant.func_110138_aP());
        }
    }

    @Override
    protected double getCollideWidthOffset() {
        return 0.8;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)2.0f, (float)2.0f);
    }

    @Override
    protected PVZZombieEntity.Type getSpawnType() {
        return PVZZombieEntity.Type.NORMAL;
    }

    @Override
    public int getSpawnTime() {
        return 40;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("guard_state")) {
            this.setGuardState(compound.func_74762_e("guard_state"));
        }
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("guard_state", this.getGuardState());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public int getGuardState() {
        return (Integer)this.field_70180_af.func_187225_a(GUARD_STATE);
    }

    public void setGuardState(int state) {
        this.field_70180_af.func_187227_b(GUARD_STATE, (Object)state);
    }

    public boolean isGuardGone(int id) {
        return (this.getGuardState() >> id & 1) == 1;
    }

    public void setGuardStateById(int id, int is) {
        int state = this.getGuardState();
        if ((is ^ state >> id & 1) == 1) {
            state ^= 1 << id;
        }
        this.field_70180_af.func_187227_b(GUARD_STATE, (Object)state);
    }

    @Override
    public float getLife() {
        return 1000.0f;
    }

    @Override
    public boolean canZombieBeRemoved() {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return null;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.COFFIN;
    }
}

