/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.other;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.drop.DropEntity;
import com.hungteen.pvz.entity.drop.SunEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RaZombieEntity
extends PVZZombieEntity {
    public static final int ABSORB_TICK = 40;
    private final Set<SunEntity> sunSet = new HashSet<SunEntity>();
    private final int MaxSearchTick = 400;
    private final int MinSearchTick = 100;
    private int searchTick = 0;
    private int sunAmount = 0;
    private final double MaxSearchRange = 20.0;

    public RaZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.19f);
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            this.tickSunSet();
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            }
            if (this.searchTick > 0) {
                --this.searchTick;
            }
            if (this.searchTick <= 0) {
                this.searchTick = this.func_70681_au().nextInt(this.MaxSearchTick - this.MinSearchTick + 1) + this.MinSearchTick;
                this.setAttackTime(40);
                EntityUtil.playSound((Entity)this, SoundEvents.field_187604_bf);
                this.field_70170_p.func_175647_a(SunEntity.class, MathUtil.getAABBWithPos(this.func_180425_c(), 20.0), sun -> sun.getDropState() != DropEntity.DropStates.STEAL && !this.sunSet.contains(sun)).forEach(sun -> {
                    sun.setDropState(DropEntity.DropStates.STEAL);
                    this.sunSet.add((SunEntity)((Object)sun));
                });
            }
        }
    }

    private void tickSunSet() {
        HashSet tmp = new HashSet();
        this.sunSet.forEach(sun -> {
            if (sun != null && !sun.field_70128_L && sun.getDropState() == DropEntity.DropStates.STEAL) {
                tmp.add(sun);
            }
        });
        this.sunSet.clear();
        this.sunSet.addAll(tmp);
        tmp.clear();
        if (!this.checkCanWorkNow()) {
            this.sunSet.forEach(sun -> sun.setDropState(DropEntity.DropStates.NORMAL));
            this.sunSet.clear();
            return;
        }
        this.sunSet.forEach(sun -> {
            double speed = 0.3;
            Vec3d now = this.func_213303_ch().func_72441_c(0.0, (double)this.func_70047_e(), 0.0);
            Vec3d vec = now.func_178788_d(sun.func_213303_ch());
            if (vec.func_72433_c() <= 2.0) {
                this.sunAmount += sun.getAmount();
                sun.func_70106_y();
            } else {
                sun.func_213317_d(vec.func_72432_b().func_186678_a(speed));
            }
        });
    }

    @Override
    protected void onZombieRemove() {
        super.onZombieRemove();
        if (!this.field_70170_p.field_72995_K) {
            SunEntity.spawnSunsByAmount(this.field_70170_p, this.func_180425_c(), this.sunAmount);
            this.sunAmount = 0;
        }
    }

    public boolean checkCanWorkNow() {
        return this.getAttackTime() > 0;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("zombie_search_tick")) {
            this.searchTick = compound.func_74762_e("zombie_search_tick");
        }
        if (compound.func_74764_b("zombie_sun_amount")) {
            this.sunAmount = compound.func_74762_e("zombie_sun_amount");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("zombie_search_tick", this.searchTick);
        compound.func_74768_a("zombie_sun_amount", this.sunAmount);
    }

    @Override
    public float getLife() {
        return 36.0f;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.RA_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.RA_ZOMBIE;
    }
}

