/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.poolday;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.PVZMultiPartEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.part.PVZZombiePartEntity;
import com.hungteen.pvz.entity.zombie.poolday.BobsleZombieEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IMultiPartEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BobsleTeamEntity
extends PVZZombieEntity
implements IMultiPartEntity {
    public static final int PART_NUM = 2;
    private PVZZombiePartEntity[] parts = new PVZZombiePartEntity[2];

    public BobsleTeamEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canBeFrozen = false;
        this.canBeButter = false;
        this.canBeMini = false;
        this.resetParts();
    }

    @Override
    public PVZZombieEntity.Type getZombieType() {
        return PVZZombieEntity.Type.NORMAL;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.27f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
    }

    @Override
    public void resetParts() {
        this.removeParts();
        for (int i = 0; i < 2; ++i) {
            this.parts[i] = new PVZZombiePartEntity(this, 1.0f, 1.5f);
            this.parts[i].setOwner((LivingEntity)this);
        }
    }

    @Override
    public void removeParts() {
        for (int i = 0; i < 2; ++i) {
            if (this.parts[i] == null) continue;
            this.parts[i].func_70106_y();
            this.parts[i] = null;
        }
    }

    @Override
    public void updateParts() {
        for (int i = 0; i < 2; ++i) {
            if (this.parts[i] == null) continue;
            if (!this.parts[i].shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.parts[i]);
            }
            float j = 6.28318f * this.field_70759_as / 360.0f;
            float dis = this.getPartOffset(i);
            Vec3d pos = this.func_213303_ch();
            this.parts[i].field_70126_B = this.field_70177_z;
            this.parts[i].field_70127_C = this.field_70125_A;
            this.parts[i].func_70012_b(pos.func_82615_a() - Math.sin(j) * (double)dis, pos.func_82617_b() + (double)0.05f, pos.func_82616_c() + Math.cos(j) * (double)dis, this.field_70177_z, this.field_70125_A);
            this.parts[i].setOwner((LivingEntity)this);
        }
    }

    @Override
    public PVZMultiPartEntity[] getParts() {
        return this.parts;
    }

    public float getPartOffset(int num) {
        if (num == 0) {
            return -1.5f;
        }
        if (num == 1) {
            return -2.5f;
        }
        return 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateParts();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && !EntityUtil.isOnSnow((Entity)this)) {
            this.func_70097_a(DamageSource.field_76369_e, 10.0f);
        }
    }

    @Override
    protected void onZombieRemove() {
        super.onZombieRemove();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                BobsleZombieEntity zombie = (BobsleZombieEntity)((EntityType)EntityRegister.BOBSLE_ZOMBIE.get()).func_200721_a(this.field_70170_p);
                EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, (MobEntity)zombie, this.func_180425_c(), 3);
            }
        }
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)1.25f, (float)1.4f);
    }

    @Override
    public float getLife() {
        return 60.0f;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.BOBSLE_TEAM;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.BOBSLE_TEAM;
    }
}

