/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.poolday;

import com.hungteen.pvz.entity.PVZMultiPartEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.entity.zombie.part.PVZZombiePartEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IMultiPartEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ZomboniEntity
extends PVZZombieEntity
implements IMultiPartEntity {
    private PVZZombiePartEntity part;

    public ZomboniEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canBeButter = false;
        this.canBeFrozen = false;
        this.resetParts();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.19f);
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (this.field_70170_p.field_72995_K && this.func_110143_aJ() <= this.func_110138_aP() / 4.0f) {
            for (int i = 1; i <= 3; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ((double)this.func_70681_au().nextFloat() - 0.5) / 10.0, 0.05, ((double)this.func_70681_au().nextFloat() - 0.5) / 10.0);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            BlockPos blockpos = this.func_180425_c();
            BlockState state = (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((IProperty)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(2));
            if ((this.field_70170_p.func_175623_d(blockpos) || this.field_70170_p.func_180495_p(blockpos).func_177230_c() == Blocks.field_150433_aE) && state.func_196955_c((IWorldReader)this.field_70170_p, blockpos)) {
                this.field_70170_p.func_175656_a(blockpos, state);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateParts();
    }

    @Override
    protected SoundEvent getSpawnSound() {
        return (SoundEvent)SoundRegister.CAR_SPAWN.get();
    }

    @Override
    public void resetParts() {
        this.removeParts();
        this.part = new PVZZombiePartEntity(this, 1.2f, 1.5f);
        this.part.setOwner((LivingEntity)this);
    }

    @Override
    public void removeParts() {
        if (this.part != null) {
            this.part.func_70106_y();
            this.part = null;
        }
    }

    @Override
    public void updateParts() {
        if (this.part != null) {
            if (!this.part.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.part);
            }
            float j = 6.28318f * this.field_70177_z / 360.0f;
            float dis = this.getPartOffset();
            Vec3d pos = this.func_213303_ch();
            this.part.field_70126_B = this.field_70177_z;
            this.part.field_70127_C = this.field_70125_A;
            this.part.func_70012_b(pos.func_82615_a() - Math.sin(j) * (double)dis, pos.func_82617_b() + (double)0.2f, pos.func_82616_c() + Math.cos(j) * (double)dis, this.field_70177_z, this.field_70125_A);
            this.part.setOwner((LivingEntity)this);
        }
    }

    @Override
    public PVZMultiPartEntity[] getParts() {
        return new PVZMultiPartEntity[]{this.part};
    }

    @Override
    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 1) {
            if (!this.field_70170_p.field_72995_K) {
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.CAR_EXPLOSION.get());
            } else {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void func_70106_y() {
        this.removeParts();
        super.func_70106_y();
    }

    @Override
    protected PVZDamageSource getZombieAttackDamageSource() {
        return PVZDamageSource.causeCrushDamage((Entity)this, (Entity)this);
    }

    public float getPartOffset() {
        if (this.isMiniZombie()) {
            return 0.4f;
        }
        return 1.2f;
    }

    @Override
    protected float getModifyAttackDamage(Entity entity, float f) {
        if (entity instanceof LivingEntity) {
            return EntityUtil.getCurrentMaxHealth((LivingEntity)entity);
        }
        return f;
    }

    @Override
    public SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)SoundRegister.METAL_HIT.get();
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        if (this.isMiniZombie()) {
            return EntitySize.func_220314_b((float)0.7f, (float)1.2f);
        }
        return EntitySize.func_220314_b((float)0.95f, (float)2.3f);
    }

    @Override
    public float getLife() {
        return 120.0f;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.ZOMBONI;
    }
}

