/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.poolnight;

import com.hungteen.pvz.capability.CapabilityHandler;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.MetalTypes;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IHasMetal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class JackInBoxZombieEntity
extends PVZZombieEntity
implements IHasMetal {
    private static final DataParameter<Boolean> HAS_BOX = EntityDataManager.func_187226_a(JackInBoxZombieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ANIM_TICK = EntityDataManager.func_187226_a(JackInBoxZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int MIN_ANIM_TICK = 20;

    public JackInBoxZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        if (!this.field_70170_p.field_72995_K) {
            this.setExplosionTime();
        }
        this.setBox(true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_BOX, (Object)true);
        this.field_70180_af.func_187214_a(ANIM_TICK, (Object)0);
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAnimTick() > 0) {
                if (this.getAnimTick() == 20) {
                    EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.JACK_SURPRISE.get());
                }
                this.setAnimTick(this.getAnimTick() - 1);
            }
            if (this.hasBox() && this.field_70173_aa % 40 == 0) {
                this.field_70170_p.func_217369_A().forEach(player -> {
                    if (this.func_70068_e((Entity)player) <= 400.0) {
                        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
                            if (l.getPlayerData().getOtherStats().playSoundTick == 0) {
                                PlayerUtil.playClientSound(player, 10);
                                l.getPlayerData().getOtherStats().playSoundTick = 300;
                            }
                        });
                    }
                });
            }
        }
        if (this.hasBox()) {
            if (this.getAnimTick() == 1) {
                if (this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 2; ++i) {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
                    }
                }
            } else if (this.getAnimTick() == 0 && !this.field_70170_p.field_72995_K && this.canExplode()) {
                this.doExplosion();
                Explosion.Mode mode = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
                this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f, mode);
                this.func_70106_y();
            }
        }
    }

    private boolean canExplode() {
        if (this.func_70638_az() == null) {
            return false;
        }
        return this.func_70068_e((Entity)this.func_70638_az()) <= 300.0;
    }

    public int func_70627_aG() {
        return 200;
    }

    private void doExplosion() {
        EntityUtil.getEntityAttackableTarget((Entity)this, EntityUtil.getEntityAABB((Entity)this, 3.0, 3.0)).forEach(entity -> {
            if (entity instanceof LivingEntity) {
                entity.func_70097_a((DamageSource)PVZDamageSource.causeExplosionDamage((Entity)this, (Entity)this), EntityUtil.getCurrentMaxHealth((LivingEntity)entity) * 2.0f);
            }
        });
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.CAR_EXPLOSION.get());
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.24f);
    }

    private void setExplosionTime() {
        int min = 200;
        int max = 2400;
        this.setAnimTick(this.func_70681_au().nextInt(max - min + 1) + min);
    }

    @Override
    public float getLife() {
        return 40.0f;
    }

    @Override
    public boolean hasMetal() {
        return this.hasBox();
    }

    @Override
    public void decreaseMetal() {
        this.setBox(false);
    }

    @Override
    public void increaseMetal() {
        this.setBox(true);
    }

    @Override
    public MetalTypes getMetalType() {
        return MetalTypes.JACK_BOX;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("has_jack_box")) {
            this.setBox(compound.func_74767_n("has_jack_box"));
        }
        if (compound.func_74764_b("jack_anim_tick")) {
            this.setAnimTick(compound.func_74762_e("jack_anim_tick"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("has_jack_box", this.hasBox());
        compound.func_74768_a("jack_anim_tick", this.getAnimTick());
    }

    public void setBox(boolean has) {
        this.field_70180_af.func_187227_b(HAS_BOX, (Object)has);
    }

    public boolean hasBox() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_BOX);
    }

    public void setAnimTick(int tick) {
        this.field_70180_af.func_187227_b(ANIM_TICK, (Object)tick);
    }

    public int getAnimTick() {
        return (Integer)this.field_70180_af.func_187225_a(ANIM_TICK);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.JACK_IN_BOX_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.JACK_IN_BOX_ZOMBIE;
    }
}

