/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.poolnight;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.entity.drop.JewelEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.Random;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class YetiZombieEntity
extends PVZZombieEntity {
    private final int DROP_JEWEL_NUM = 4;
    private final double[] DD = new double[]{-0.5, 0.5, 0.5, -0.5};
    private int live_tick = 0;
    private boolean hasInvis = false;

    public YetiZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canBeFrozen = false;
    }

    @Override
    public float getLife() {
        return 135.0f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.22f);
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            ++this.live_tick;
            if (this.live_tick > this.getYetiMaxLiveTick() / 2) {
                if (!this.hasInvis) {
                    this.hasInvis = true;
                    this.func_195064_c(new EffectInstance(Effects.field_76441_p, 2000, 2, false, true));
                }
                this.func_70691_i(0.5f);
            } else if (this.live_tick >= this.getYetiMaxLiveTick()) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        if (this.isMiniZombie()) {
            return EntitySize.func_220314_b((float)0.6f, (float)1.2f);
        }
        return EntitySize.func_220314_b((float)1.0f, (float)2.6f);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (amount >= 100.0f) {
            amount /= 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    protected void dropCoinOrSpecial() {
        for (int i = 0; i < this.DROP_JEWEL_NUM; ++i) {
            JewelEntity jewel = (JewelEntity)((EntityType)EntityRegister.JEWEL.get()).func_200721_a(this.field_70170_p);
            EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, jewel, this.func_180425_c().func_177963_a(this.DD[i], this.func_70681_au().nextDouble(), this.DD[(i + 1) % this.DROP_JEWEL_NUM]));
        }
    }

    public int getYetiMaxLiveTick() {
        return (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.EntityLiveTick.YetiLiveTick.get();
    }

    public static boolean canYetiSpawn(EntityType<? extends PVZZombieEntity> zombieType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        if (YetiZombieEntity.canZombieSpawn(zombieType, worldIn, reason, pos, rand)) {
            return worldIn instanceof ServerWorld && ((ServerWorld)worldIn).func_72911_I() && !((ServerWorld)worldIn).func_72935_r() && rand.nextInt(2) == 0;
        }
        return false;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("yeti_live_tick", this.live_tick);
        compound.func_74757_a("yeti_invis", this.hasInvis);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("yeti_live_tick")) {
            this.live_tick = compound.func_74762_e("yeti_live_tick");
        }
        if (compound.func_74764_b("yeti_invis")) {
            this.hasInvis = compound.func_74767_n("yeti_invis");
        }
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.YETI_ZOMBIE;
    }
}

