/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.roof;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.ai.target.PVZRandomTargetGoal;
import com.hungteen.pvz.entity.bullet.TargetArrowEntity;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BungeeZombieEntity
extends PVZZombieEntity {
    public static final Zombies[] ZOMBIES = new Zombies[]{Zombies.NORMAL_ZOMBIE, Zombies.CONEHEAD_ZOMBIE, Zombies.BUCKETHEAD_ZOMBIE, Zombies.SCREENDOOR_ZOMBIE};
    private static final DataParameter<Integer> BUNGEE_STATE = EntityDataManager.func_187226_a(BungeeZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BUNGEE_TYPE = EntityDataManager.func_187226_a(BungeeZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> ORIGIN_POS = EntityDataManager.func_187226_a(BungeeZombieEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private LivingEntity stealTarget;

    public BungeeZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canBeMini = false;
        this.canBeButter = false;
        this.canBeFrozen = false;
        this.canBeStealByBungee = false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BUNGEE_STATE, (Object)BungeeStates.WAIT.ordinal());
        this.field_70180_af.func_187214_a(BUNGEE_TYPE, (Object)BungeeTypes.STEAL.ordinal());
        this.field_70180_af.func_187214_a(ORIGIN_POS, (Object)BlockPos.field_177992_a);
    }

    @Override
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setOriginPos(this.func_180425_c());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (Goal)new BungeeRandomTargetGoal((MobEntity)this, true, 50.0f, 60.0f));
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getBungeeState() == BungeeStates.PUSH_BACK) {
                this.setAttackTime(this.getAttackTime() - 1);
                this.func_213317_d(new Vec3d(0.0, 1.2, 0.0));
                if (this.getAttackTime() <= -60) {
                    this.func_70106_y();
                    if (this.getBungeeType() == BungeeTypes.SUMMON && EntityUtil.isEntityValid((Entity)this.getStealTarget())) {
                        this.getStealTarget().func_70106_y();
                    }
                }
                return;
            }
            if (this.getBungeeType() == BungeeTypes.STEAL) {
                this.tickSteal();
            } else if (this.getBungeeType() == BungeeTypes.HELP) {
                this.tickHelp();
            } else if (this.getBungeeType() == BungeeTypes.SUMMON) {
                this.tickSummon();
            }
        }
    }

    protected void tickHelp() {
        if (!this.isSuitableTarget(this.getStealTarget())) {
            if (this.getAttackTime() >= 0) {
                this.setAttackTime(-1);
            }
            this.setBungeeState(BungeeStates.UP);
        }
        if (this.getBungeeState() == BungeeStates.WAIT) {
            if (this.isSuitableTarget(this.getStealTarget())) {
                this.setBungeeState(BungeeStates.DOWN);
                EntityUtil.playSound((Entity)this.getStealTarget(), (SoundEvent)SoundRegister.BUNGEE_SCREAM.get());
            }
        } else if (this.getBungeeState() == BungeeStates.DOWN) {
            if (this.isNearToTarget()) {
                this.setAttackTime(this.getStayTime());
                this.getStealTarget().func_184220_m((Entity)this);
                this.setBungeeState(BungeeStates.CATCH);
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DRAG.get());
            } else {
                this.moveToTarget();
            }
        } else if (this.getBungeeState() == BungeeStates.CATCH) {
            this.func_213317_d(Vec3d.field_186680_a);
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            }
            if (this.getAttackTime() == 0) {
                this.setBungeeState(BungeeStates.UP);
            }
        } else if (this.getBungeeState() == BungeeStates.UP) {
            this.setAttackTime(this.getAttackTime() - 1);
            this.moveBackToOrigin();
            if (this.getAttackTime() < -60) {
                this.dealDamage();
                return;
            }
        }
    }

    protected void tickSteal() {
        if (this.getBungeeState() != BungeeStates.WAIT && !this.isSuitableTarget(this.getStealTarget())) {
            this.setBungeeState(BungeeStates.BACK_WAIT);
        }
        if (this.getBungeeState() == BungeeStates.WAIT) {
            if (this.isSuitableTarget(this.func_70638_az())) {
                if (this.func_226278_cu_() - this.func_70638_az().func_226278_cu_() <= 15.0) {
                    this.setOriginPos(this.func_70638_az().func_180425_c().func_177981_b(20));
                    this.setBungeeState(BungeeStates.BACK_WAIT);
                    return;
                }
                this.setBungeeState(BungeeStates.DOWN);
                this.setStealTarget(this.func_70638_az());
                this.shootArrowToTarget();
                EntityUtil.playSound((Entity)this.getStealTarget(), (SoundEvent)SoundRegister.BUNGEE_SCREAM.get());
            }
        } else if (this.getBungeeState() == BungeeStates.BACK_WAIT) {
            this.moveBackToOrigin();
            if (this.func_70092_e(this.getOriginPos().func_177958_n(), this.getOriginPos().func_177956_o(), this.getOriginPos().func_177952_p()) <= 2.0) {
                this.setBungeeState(BungeeStates.WAIT);
                this.func_213317_d(Vec3d.field_186680_a);
            }
        } else if (this.getBungeeState() == BungeeStates.DOWN) {
            if (this.isNearToTarget()) {
                this.setAttackTime(this.getStayTime());
                this.getStealTarget().func_184220_m((Entity)this);
                this.setBungeeState(BungeeStates.CATCH);
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DRAG.get());
            } else {
                this.moveToTarget();
            }
        } else if (this.getBungeeState() == BungeeStates.CATCH) {
            this.func_213317_d(Vec3d.field_186680_a);
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            }
            this.getStealTarget().func_184220_m((Entity)this);
            if (this.getAttackTime() == 0) {
                this.setBungeeState(BungeeStates.UP);
            }
        } else if (this.getBungeeState() == BungeeStates.UP) {
            this.setAttackTime(this.getAttackTime() - 1);
            this.moveBackToOrigin();
            this.getStealTarget().func_184220_m((Entity)this);
            if (this.getAttackTime() < -60) {
                this.dealDamage();
                return;
            }
        }
    }

    public void pushBack() {
        this.setBungeeState(BungeeStates.PUSH_BACK);
    }

    @Override
    public boolean checkCanZombieTarget(LivingEntity target) {
        if (!BungeeZombieEntity.canBungeeSteal((Entity)target)) {
            return false;
        }
        return super.checkCanZombieTarget(target);
    }

    protected void tickSummon() {
        if (this.getBungeeState() != BungeeStates.WAIT && !EntityUtil.isEntityValid((Entity)this.getStealTarget())) {
            this.setBungeeState(BungeeStates.UP);
        }
        if (this.getBungeeState() == BungeeStates.WAIT) {
            if (this.func_184188_bt().isEmpty()) {
                this.summonZombie();
                this.setBungeeState(BungeeStates.DOWN);
                EntityUtil.playSound((Entity)this.getStealTarget(), (SoundEvent)SoundRegister.BUNGEE_SCREAM.get());
            }
        } else if (this.getBungeeState() == BungeeStates.DOWN) {
            if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() != Blocks.field_150350_a) {
                this.getStealTarget().func_184210_p();
                this.setAttackTime(0);
                this.setBungeeState(BungeeStates.UP);
            } else {
                this.getStealTarget().func_184220_m((Entity)this);
                this.func_213317_d(new Vec3d(0.0, -0.5, 0.0));
            }
        } else if (this.getBungeeState() == BungeeStates.UP) {
            this.moveBackToOrigin();
            this.setAttackTime(this.getAttackTime() - 1);
            if (this.getAttackTime() < -60) {
                this.func_70106_y();
                return;
            }
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return this.getBungeeState() != BungeeStates.CATCH || super.func_180431_b(source);
    }

    private void summonZombie() {
        int pos = this.func_70681_au().nextInt(ZOMBIES.length);
        Zombies type = ZOMBIES[pos];
        PVZZombieEntity zombie = ZombieUtil.getZombieEntity(this.field_70170_p, type);
        EntityUtil.onMobEntitySpawn((IWorld)this.field_70170_p, (MobEntity)zombie, this.func_180425_c());
        zombie.func_184220_m((Entity)this);
        this.setStealTarget((LivingEntity)zombie);
    }

    public double func_70042_X() {
        return 0.0;
    }

    private boolean isSuitableTarget(LivingEntity target) {
        if (!EntityUtil.isEntityValid((Entity)target)) {
            return false;
        }
        if (target instanceof BungeeZombieEntity) {
            return false;
        }
        if (target.func_184187_bx() instanceof BungeeZombieEntity) {
            return target.func_184187_bx().func_70028_i((Entity)this);
        }
        return true;
    }

    private void dealDamage() {
        this.getStealTarget().func_70097_a((DamageSource)PVZDamageSource.causeNormalDamage((Entity)this, (Entity)this), EntityUtil.getCurrentMaxHealth(this.getStealTarget()));
        this.func_70106_y();
    }

    public int getStayTime() {
        return 60;
    }

    private void moveToTarget() {
        if (this.getStealTarget() == null) {
            return;
        }
        Vec3d vec = this.getStealTarget().func_213303_ch().func_178788_d(this.func_213303_ch()).func_72432_b();
        double speed = 0.5;
        this.func_213317_d(vec.func_216372_d(speed, speed, speed));
    }

    private void moveBackToOrigin() {
        Vec3d vec = new Vec3d((double)this.getOriginPos().func_177958_n() - this.func_226277_ct_(), (double)this.getOriginPos().func_177956_o() - this.func_226278_cu_(), (double)this.getOriginPos().func_177952_p() - this.func_226281_cx_()).func_72432_b();
        double speed = 0.35;
        this.func_213317_d(vec.func_216372_d(speed, speed, speed));
    }

    private boolean isNearToTarget() {
        if (this.getStealTarget() == null) {
            return false;
        }
        return this.func_70068_e((Entity)this.getStealTarget()) <= 2.0;
    }

    private void shootArrowToTarget() {
        TargetArrowEntity arrow = new TargetArrowEntity(this.field_70170_p, (LivingEntity)this);
        arrow.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        arrow.shoot(this.getStealTarget());
        this.field_70170_p.func_217376_c((Entity)arrow);
    }

    @Override
    public float getLife() {
        return 45.0f;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)1.2f, (float)2.0f);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.BUNGEE_ZOMBIE;
    }

    public boolean func_205710_ba() {
        return true;
    }

    public boolean func_189652_ae() {
        return true;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("bungee_state")) {
            this.setBungeeState(BungeeStates.values()[compound.func_74762_e("bungee_state")]);
        }
        if (compound.func_74764_b("bungee_type")) {
            this.setBungeeType(BungeeTypes.values()[compound.func_74762_e("bungee_type")]);
        }
        if (compound.func_74764_b("steal_target")) {
            this.stealTarget = (LivingEntity)this.field_70170_p.func_73045_a(compound.func_74762_e("steal_target"));
        }
        if (compound.func_74764_b("origin_pos")) {
            CompoundNBT nbt = compound.func_74775_l("origin_pos");
            this.setOriginPos(new BlockPos(nbt.func_74762_e("origin_pos_x"), nbt.func_74762_e("origin_pos_y"), nbt.func_74762_e("origin_pos_z")));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("bungee_state", this.getBungeeState().ordinal());
        compound.func_74768_a("bungee_type", this.getBungeeType().ordinal());
        if (this.stealTarget != null) {
            compound.func_74768_a("steal_target", this.stealTarget.func_145782_y());
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("origin_pos_x", this.getOriginPos().func_177958_n());
        nbt.func_74768_a("origin_pos_y", this.getOriginPos().func_177956_o());
        nbt.func_74768_a("origin_pos_z", this.getOriginPos().func_177952_p());
        compound.func_218657_a("origin_pos", (INBT)nbt);
    }

    public void setBungeeState(BungeeStates state) {
        this.field_70180_af.func_187227_b(BUNGEE_STATE, (Object)state.ordinal());
    }

    public void setBungeeType(BungeeTypes type) {
        this.field_70180_af.func_187227_b(BUNGEE_TYPE, (Object)type.ordinal());
    }

    public BungeeStates getBungeeState() {
        return BungeeStates.values()[(Integer)this.field_70180_af.func_187225_a(BUNGEE_STATE)];
    }

    public BungeeTypes getBungeeType() {
        return BungeeTypes.values()[(Integer)this.field_70180_af.func_187225_a(BUNGEE_TYPE)];
    }

    public BlockPos getOriginPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN_POS);
    }

    public void setOriginPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(ORIGIN_POS, (Object)pos);
    }

    public LivingEntity getStealTarget() {
        return this.stealTarget;
    }

    public void setStealTarget(LivingEntity target) {
        this.stealTarget = target;
    }

    public static boolean canBungeeSteal(Entity target) {
        if (!target.func_184222_aU()) {
            return false;
        }
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        if (target instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)target).canBeStealByBungee();
        }
        if (target instanceof PVZPlantEntity) {
            return true;
        }
        return ((LivingEntity)target).func_110138_aP() < 100.0f;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.BUNGEE_ZOMBIE;
    }

    public static class BungeeRandomTargetGoal
    extends PVZRandomTargetGoal {
        public BungeeRandomTargetGoal(MobEntity mobIn, boolean checkSight, float w, float h) {
            super(mobIn, checkSight, w, h);
        }

        @Override
        public boolean func_75253_b() {
            LivingEntity entity = this.field_75299_d.func_70638_az();
            if (entity == null) {
                entity = this.field_188509_g;
            }
            if (entity == null || !entity.func_70089_S()) {
                return false;
            }
            if (EntityUtil.checkCanEntityTarget((Entity)this.field_75299_d, entity) && entity != this.field_75299_d && this.checkOther(entity)) {
                this.field_75299_d.func_70624_b(entity);
                return true;
            }
            return false;
        }
    }

    public static enum BungeeTypes {
        STEAL,
        HELP,
        SUMMON;

    }

    public static enum BungeeStates {
        WAIT,
        BACK_WAIT,
        DOWN,
        CATCH,
        UP,
        PUSH_BACK;

    }
}

