/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.roof;

import com.hungteen.pvz.entity.ai.attack.PultAttackGoal;
import com.hungteen.pvz.entity.bullet.BallEntity;
import com.hungteen.pvz.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IPult;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class CatapultZombieEntity
extends PVZZombieEntity
implements IPult {
    private static final DataParameter<Integer> BALL_COUNT = EntityDataManager.func_187226_a(CatapultZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final float PULT_DISTANCE = 2000.0f;

    public CatapultZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canBeButter = false;
        this.canBeFrozen = false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.19f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BALL_COUNT, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new CataPultAttackGoal(this));
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K && this.getAttackTime() > 0) {
            this.setAttackTime(this.getAttackTime() - 1);
            if (this.getAttackTime() == this.getPultAnimTime() / 2) {
                this.pultBullet();
            }
        }
    }

    @Override
    public void startPultAttack() {
        this.setAttackTime(this.getPultAnimTime());
    }

    @Override
    public int getPultCD() {
        return 60;
    }

    public int getPultAnimTime() {
        return 20;
    }

    @Override
    public float getPultRange() {
        return 40.0f;
    }

    @Override
    public boolean shouldPult() {
        return this.getBallCount() < this.getMaxBallUse();
    }

    public boolean checkY(LivingEntity target) {
        return this.func_226278_cu_() + 9.0 >= target.func_226278_cu_() + (double)target.func_213302_cg();
    }

    @Override
    protected PVZDamageSource getZombieAttackDamageSource() {
        return PVZDamageSource.causeCrushDamage((Entity)this, (Entity)this);
    }

    @Override
    protected float getModifyAttackDamage(Entity entity, float f) {
        if (entity instanceof LivingEntity) {
            return EntityUtil.getCurrentMaxHealth((LivingEntity)entity);
        }
        return f;
    }

    @Override
    public void pultBullet() {
        LivingEntity target = this.func_70638_az();
        if (target == null) {
            return;
        }
        BallEntity ball = new BallEntity(this.field_70170_p, (LivingEntity)this);
        ball.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)1.7f, this.func_226281_cx_());
        ball.shootPultBullet(target);
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.BASKETBALL.get());
        this.field_70170_p.func_217376_c((Entity)ball);
        this.setBallCount(this.getBallCount() + 1);
    }

    @Override
    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 1) {
            if (!this.field_70170_p.field_72995_K) {
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.CAR_EXPLOSION.get());
            } else {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public int getMaxBallUse() {
        return 50;
    }

    public float getAttackDamage() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        if (this.isMiniZombie()) {
            return EntitySize.func_220314_b((float)0.6f, (float)1.1f);
        }
        return EntitySize.func_220314_b((float)0.9f, (float)2.0f);
    }

    @Override
    public float getLife() {
        return 105.0f;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("ball_count")) {
            this.setBallCount(compound.func_74762_e("ball_count"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ball_count", this.getBallCount());
    }

    public void setBallCount(int cnt) {
        this.field_70180_af.func_187227_b(BALL_COUNT, (Object)cnt);
    }

    public int getBallCount() {
        return (Integer)this.field_70180_af.func_187225_a(BALL_COUNT);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.CATAPULT_ZOMBIE;
    }

    private static final class CataPultAttackGoal
    extends PultAttackGoal {
        private final CatapultZombieEntity zombie;

        public CataPultAttackGoal(IPult pult) {
            super(pult);
            this.zombie = (CatapultZombieEntity)pult;
            if (!(pult instanceof CatapultZombieEntity)) {
                System.out.println("ERROR : Wrong Pult Attack AI Owner !");
            }
        }

        @Override
        public void func_75251_c() {
            this.target = null;
        }

        @Override
        protected boolean checkTarget(LivingEntity target) {
            return super.checkTarget(target) && this.attacker.func_70068_e((Entity)target) <= 2000.0 && this.zombie.checkY(target);
        }
    }
}

