/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.roof;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.entity.plant.base.PlantDefenderEntity;
import com.hungteen.pvz.entity.zombie.base.DefenceZombieEntity;
import com.hungteen.pvz.entity.zombie.part.PVZHealthPartEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.enums.MetalTypes;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IHasMetal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class LadderZombieEntity
extends DefenceZombieEntity
implements IHasMetal {
    public LadderZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.24f);
    }

    @Override
    public void resetParts() {
        this.removeParts();
        this.part = new PVZHealthPartEntity(this, 1.0f, 1.7f);
        this.part.setOwner((LivingEntity)this);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (this.hasMetal() && LadderZombieEntity.canTargetPutLadder(entityIn)) {
            this.decreaseMetal();
            PVZPlantEntity plant = (PVZPlantEntity)entityIn;
            plant.increaseMetal();
        }
        return super.func_70652_k(entityIn);
    }

    public static boolean canTargetPutLadder(Entity target) {
        if (!(target instanceof PVZPlantEntity)) {
            return false;
        }
        if (LadderZombieEntity.hasLadderOnEntity(target)) {
            return false;
        }
        if (target instanceof PlantDefenderEntity) {
            return true;
        }
        PVZPlantEntity plant = (PVZPlantEntity)target;
        return plant.getOuterPlantType().isPresent() && plant.getOuterPlantType().get() == Plants.PUMPKIN;
    }

    public static boolean hasLadderOnEntity(Entity target) {
        if (!(target instanceof PVZPlantEntity)) {
            return false;
        }
        PVZPlantEntity plant = (PVZPlantEntity)target;
        return plant.hasMetal();
    }

    @Override
    public boolean hasMetal() {
        return this.getDefenceLife() > 0.0f;
    }

    @Override
    public void decreaseMetal() {
        this.setDefenceLife(0.0f);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    @Override
    public void increaseMetal() {
        this.setDefenceLife(this.getPartLife());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.24f);
        this.resetParts();
    }

    @Override
    public MetalTypes getMetalType() {
        return MetalTypes.LADDER;
    }

    @Override
    public SoundEvent getPartHurtSound() {
        return (SoundEvent)SoundRegister.METAL_HIT.get();
    }

    @Override
    public float getLife() {
        return 65.0f;
    }

    @Override
    public float getPartLife() {
        return 250.0f;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.LADDER_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.LADDER_ZOMBIE;
    }
}

