/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.entity.zombie.roof;

import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.entity.zombie.roof.GargantuarEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class SadGargantuarEntity
extends GargantuarEntity {
    public SadGargantuarEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.isSad = true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.19f);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.GROUND_SHAKE.get());
        }
        this.groundShack(entityIn);
        if (!EntityUtil.isEntityValid(entityIn)) {
            return false;
        }
        return super.func_70652_k(entityIn);
    }

    private void groundShack(Entity entity) {
        float range = 3.0f;
        EntityUtil.getEntityTargetableEntity((Entity)this, EntityUtil.getEntityAABB((Entity)this, range, range)).forEach(target -> {
            if (!target.func_70028_i(entity)) {
                target.func_70097_a((DamageSource)this.getZombieAttackDamageSource(), EntityUtil.getCurrentMaxHealth(target) / 2.0f);
                for (int i = 0; i < 5; ++i) {
                    EntityUtil.spawnParticle((Entity)target, 6);
                }
            }
        });
    }

    @Override
    protected float getModifyAttackDamage(Entity entity, float f) {
        if (entity instanceof LivingEntity) {
            return 4.0f * EntityUtil.getCurrentMaxHealth((LivingEntity)entity);
        }
        return f;
    }

    @Override
    public void throwImp(LivingEntity target) {
        for (int i = 0; i < 3; ++i) {
            super.throwImp(target);
        }
    }

    @Override
    public float getLife() {
        return 600.0f;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        if (this.isMiniZombie()) {
            return EntitySize.func_220314_b((float)0.7f, (float)2.0f);
        }
        return super.func_213305_a(poseIn);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.SAD_GARGANTUAR;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.SAD_GARGANTUAR;
    }
}

